/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.DistributedCacheClear;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericEntityNotFoundException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.GenericHelperFactory;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.LockedDatabaseGenericDelegator;
import org.ofbiz.core.entity.SequenceUtil;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.entity.config.DatasourceInfo;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.eca.EntityEcaHandler;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelGroupReader;
import org.ofbiz.core.entity.model.ModelKeyMap;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelRelation;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilMisc;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class GenericDelegator
implements DelegatorInterface {
    private static boolean isLocked = false;
    public static final String module = GenericDelegator.class.getName();
    protected static Map<String, GenericDelegator> delegatorCache = CopyOnWriteMap.newHashMap();
    protected String delegatorName;
    protected EntityConfigUtil.DelegatorInfo delegatorInfo = null;
    public final boolean keepLocalReaders = true;
    protected ModelReader modelReader = null;
    protected ModelGroupReader modelGroupReader = null;
    protected UtilCache primaryKeyCache = null;
    protected UtilCache allCache = null;
    protected UtilCache andCache = null;
    protected Map andCacheFieldSets = new HashMap();
    protected DistributedCacheClear distributedCacheClear = null;
    protected EntityEcaHandler entityEcaHandler = null;
    public static final String ECA_HANDLER_CLASS_NAME = "org.ofbiz.core.extentity.eca.DelegatorEcaHandler";
    protected SequenceUtil sequencer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GenericDelegator getGenericDelegator(String delegatorName) {
        GenericDelegator delegator = delegatorCache.get(delegatorName);
        if (delegator != null) return delegator;
        Class<GenericDelegator> clazz = GenericDelegator.class;
        synchronized (GenericDelegator.class) {
            delegator = delegatorCache.get(delegatorName);
            if (delegator != null) return delegator;
            try {
                delegator = isLocked ? new LockedDatabaseGenericDelegator() : new GenericDelegator(delegatorName);
            }
            catch (GenericEntityException e) {
                Debug.logError((Throwable)((Object)e), (String)"Error creating delegator", (String)module);
            }
            if (delegator == null) return delegator;
            delegatorCache.put(delegatorName, delegator);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return delegator;
        }
    }

    public static synchronized void removeGenericDelegator(String delegatorName) {
        delegatorCache.remove(delegatorName);
    }

    public static void lock() {
        isLocked = true;
    }

    protected GenericDelegator() {
    }

    protected GenericDelegator(String delegatorName) throws GenericEntityException {
        if (Debug.infoOn()) {
            Debug.logInfo((String)("Creating new Delegator with name \"" + delegatorName + "\"."), (String)module);
        }
        this.delegatorName = delegatorName;
        this.modelReader = ModelReader.getModelReader(delegatorName);
        this.modelGroupReader = ModelGroupReader.getModelGroupReader(delegatorName);
        this.primaryKeyCache = new UtilCache("entity.FindByPrimaryKey." + delegatorName, 0L, 0L, true);
        this.allCache = new UtilCache("entity.FindAll." + delegatorName, 0L, 0L, true);
        this.andCache = new UtilCache("entity.FindByAnd." + delegatorName, 0L, 0L, true);
        Iterator groups = UtilMisc.toIterator((Collection)this.getModelGroupReader().getGroupNames());
        while (groups != null && groups.hasNext()) {
            String groupName = (String)groups.next();
            String helperName = this.getGroupHelperName(groupName);
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Delegator \"" + delegatorName + "\" initializing helper \"" + helperName + "\" for entity group \"" + groupName + "\"."), (String)module);
            }
            TreeSet<String> helpersDone = new TreeSet<String>();
            if (helperName == null || helperName.length() <= 0) continue;
            if (helpersDone.contains(helperName)) {
                if (!Debug.infoOn()) continue;
                Debug.logInfo((String)("Helper \"" + helperName + "\" already initialized, not re-initializing."), (String)module);
                continue;
            }
            helpersDone.add(helperName);
            ModelFieldTypeReader.getModelFieldTypeReader(helperName);
            GenericHelper helper = GenericHelperFactory.getHelper(helperName);
            DatasourceInfo datasourceInfo = EntityConfigUtil.getInstance().getDatasourceInfo(helperName);
            if (!datasourceInfo.isCheckOnStart()) continue;
            if (Debug.infoOn()) {
                Debug.logInfo((String)("Doing database check as requested in entityengine.xml with addMissing=" + datasourceInfo.isAddMissingOnStart()), (String)module);
            }
            try {
                helper.checkDataSource(this.getModelEntityMapByGroup(groupName), null, datasourceInfo.isAddMissingOnStart());
            }
            catch (GenericEntityException e) {
                Debug.logWarning((String)e.getMessage(), (String)module);
            }
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.getDelegatorInfo().useDistributedCacheClear) {
            String distributedCacheClearClassName = this.getDelegatorInfo().distributedCacheClearClassName;
            try {
                Class<?> dccClass = loader.loadClass(distributedCacheClearClassName);
                this.distributedCacheClear = (DistributedCacheClear)dccClass.newInstance();
                this.distributedCacheClear.setDelegator(this, this.getDelegatorInfo().distributedCacheClearUserLoginId);
            }
            catch (ClassNotFoundException e) {
                Debug.logWarning((Throwable)e, (String)("DistributedCacheClear class with name " + distributedCacheClearClassName + " was not found, distributed cache clearing will be disabled"));
            }
            catch (InstantiationException e) {
                Debug.logWarning((Throwable)e, (String)("DistributedCacheClear class with name " + distributedCacheClearClassName + " could not be instantiated, distributed cache clearing will be disabled"));
            }
            catch (IllegalAccessException e) {
                Debug.logWarning((Throwable)e, (String)("DistributedCacheClear class with name " + distributedCacheClearClassName + " could not be accessed (illegal), distributed cache clearing will be disabled"));
            }
            catch (ClassCastException e) {
                Debug.logWarning((Throwable)e, (String)("DistributedCacheClear class with name " + distributedCacheClearClassName + " does not implement the DistributedCacheClear interface, distributed cache clearing will be disabled"));
            }
        }
        try {
            Class<?> eecahClass = loader.loadClass(ECA_HANDLER_CLASS_NAME);
            this.entityEcaHandler = (EntityEcaHandler)eecahClass.newInstance();
            this.entityEcaHandler.setDelegator(this);
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
            Debug.logWarning((Throwable)e, (String)"EntityEcaHandler class with name org.ofbiz.core.extentity.eca.DelegatorEcaHandler could not be instantiated, Entity ECA Rules will be disabled");
        }
        catch (IllegalAccessException e) {
            Debug.logWarning((Throwable)e, (String)"EntityEcaHandler class with name org.ofbiz.core.extentity.eca.DelegatorEcaHandler could not be accessed (illegal), Entity ECA Rules will be disabled");
        }
        catch (ClassCastException e) {
            Debug.logWarning((Throwable)e, (String)"EntityEcaHandler class with name org.ofbiz.core.extentity.eca.DelegatorEcaHandler does not implement the EntityEcaHandler interface, Entity ECA Rules will be disabled");
        }
    }

    public String getDelegatorName() {
        return this.delegatorName;
    }

    protected EntityConfigUtil.DelegatorInfo getDelegatorInfo() {
        if (this.delegatorInfo == null) {
            this.delegatorInfo = EntityConfigUtil.getInstance().getDelegatorInfo(this.delegatorName);
        }
        return this.delegatorInfo;
    }

    public ModelReader getModelReader() {
        return this.modelReader;
    }

    public ModelGroupReader getModelGroupReader() {
        return this.modelGroupReader;
    }

    public ModelEntity getModelEntity(String entityName) {
        try {
            return this.getModelReader().getModelEntity(entityName);
        }
        catch (GenericEntityException e) {
            Debug.logError((Throwable)((Object)e), (String)"Error getting entity definition from model", (String)module);
            return null;
        }
    }

    public String getEntityGroupName(String entityName) {
        String groupName = this.getModelGroupReader().getEntityGroupName(entityName);
        return groupName;
    }

    public List getModelEntitiesByGroup(String groupName) {
        Iterator enames = UtilMisc.toIterator((Collection)this.getModelGroupReader().getEntityNamesByGroup(groupName));
        LinkedList<ModelEntity> entities = new LinkedList<ModelEntity>();
        if (enames == null || !enames.hasNext()) {
            return entities;
        }
        while (enames.hasNext()) {
            String ename = (String)enames.next();
            ModelEntity entity = this.getModelEntity(ename);
            if (entity == null) continue;
            entities.add(entity);
        }
        return entities;
    }

    public Map getModelEntityMapByGroup(String groupName) {
        Iterator enames = UtilMisc.toIterator((Collection)this.getModelGroupReader().getEntityNamesByGroup(groupName));
        HashMap<String, ModelEntity> entities = new HashMap<String, ModelEntity>();
        if (enames == null || !enames.hasNext()) {
            return entities;
        }
        int errorCount = 0;
        while (enames.hasNext()) {
            String ename = (String)enames.next();
            try {
                ModelEntity entity = this.getModelReader().getModelEntity(ename);
                if (entity != null) {
                    entities.put(entity.getEntityName(), entity);
                    continue;
                }
                throw new IllegalStateException("Programm Error: entity was null with name " + ename);
            }
            catch (GenericEntityException ex) {
                ++errorCount;
                Debug.logError((String)("Entity " + ename + " named in Entity Group with name " + groupName + " are not defined in any Entity Definition file"));
            }
        }
        if (errorCount > 0) {
            Debug.logError((String)(errorCount + " entities were named in ModelGroup but not defined in any EntityModel"));
        }
        return entities;
    }

    public String getGroupHelperName(String groupName) {
        EntityConfigUtil.DelegatorInfo delegatorInfo = this.getDelegatorInfo();
        return delegatorInfo.groupMap.get(groupName);
    }

    public String getEntityHelperName(String entityName) {
        String groupName = this.getModelGroupReader().getEntityGroupName(entityName);
        return this.getGroupHelperName(groupName);
    }

    public String getEntityHelperName(ModelEntity entity) {
        if (entity == null) {
            return null;
        }
        return this.getEntityHelperName(entity.getEntityName());
    }

    public GenericHelper getEntityHelper(String entityName) throws GenericEntityException {
        String helperName = this.getEntityHelperName(entityName);
        if (helperName != null && helperName.length() > 0) {
            return GenericHelperFactory.getHelper(helperName);
        }
        throw new GenericEntityException("Helper name not found for entity " + entityName);
    }

    public GenericHelper getEntityHelper(ModelEntity entity) throws GenericEntityException {
        return this.getEntityHelper(entity.getEntityName());
    }

    public ModelFieldType getEntityFieldType(ModelEntity entity, String type) throws GenericEntityException {
        String helperName = this.getEntityHelperName(entity);
        if (helperName == null || helperName.length() <= 0) {
            return null;
        }
        ModelFieldTypeReader modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
        if (modelFieldTypeReader == null) {
            throw new GenericEntityException("ModelFieldTypeReader not found for entity " + entity.getEntityName() + " with helper name " + helperName);
        }
        return modelFieldTypeReader.getModelFieldType(type);
    }

    public Collection getEntityFieldTypeNames(ModelEntity entity) throws GenericEntityException {
        String helperName = this.getEntityHelperName(entity);
        if (helperName == null || helperName.length() <= 0) {
            return null;
        }
        ModelFieldTypeReader modelFieldTypeReader = ModelFieldTypeReader.getModelFieldTypeReader(helperName);
        if (modelFieldTypeReader == null) {
            throw new GenericEntityException("ModelFieldTypeReader not found for entity " + entity.getEntityName() + " with helper name " + helperName);
        }
        return modelFieldTypeReader.getFieldTypeNames();
    }

    public GenericValue makeValue(String entityName, Map fields) {
        ModelEntity entity = this.getModelEntity(entityName);
        if (entity == null) {
            throw new IllegalArgumentException("[GenericDelegator.makeValue] could not find entity for entityName: " + entityName);
        }
        GenericValue value = new GenericValue(entity, fields);
        value.setDelegator(this);
        return value;
    }

    public GenericPK makePK(String entityName, Map fields) {
        ModelEntity entity = this.getModelEntity(entityName);
        if (entity == null) {
            throw new IllegalArgumentException("[GenericDelegator.makePK] could not find entity for entityName: " + entityName);
        }
        GenericPK pk = new GenericPK(entity, fields);
        pk.setDelegator(this);
        return pk;
    }

    public GenericValue create(String entityName, Map fields) throws GenericEntityException {
        if (entityName == null || fields == null) {
            return null;
        }
        ModelEntity entity = this.getModelReader().getModelEntity(entityName);
        GenericValue genericValue = new GenericValue(entity, fields);
        return this.create(genericValue, true);
    }

    public GenericValue create(GenericValue value) throws GenericEntityException {
        return this.create(value, true);
    }

    public GenericValue create(GenericValue value, boolean doCacheClear) throws GenericEntityException {
        Map ecaEventMap;
        this.evalEcaRules("validate", "create", value, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(value.getEntityName())) == null, false);
        if (value == null) {
            throw new IllegalArgumentException("Cannot create a null value");
        }
        GenericHelper helper = this.getEntityHelper(value.getEntityName());
        this.evalEcaRules("run", "create", value, ecaEventMap, ecaEventMap == null, false);
        value.setDelegator(this);
        value = helper.create(value);
        if (value != null) {
            value.setDelegator(this);
            if (value.lockEnabled()) {
                this.refresh(value, doCacheClear);
            } else if (doCacheClear) {
                this.evalEcaRules("cache-clear", "create", value, ecaEventMap, ecaEventMap == null, false);
                this.clearCacheLine(value);
            }
        }
        this.evalEcaRules("return", "create", value, ecaEventMap, ecaEventMap == null, false);
        return value;
    }

    public GenericValue create(GenericPK primaryKey) throws GenericEntityException {
        return this.create(primaryKey, true);
    }

    public GenericValue create(GenericPK primaryKey, boolean doCacheClear) throws GenericEntityException {
        if (primaryKey == null) {
            throw new IllegalArgumentException("Cannot create from a null primaryKey");
        }
        return this.create(new GenericValue(primaryKey), doCacheClear);
    }

    public GenericValue findByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        Map ecaEventMap;
        this.evalEcaRules("validate", "find", primaryKey, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(primaryKey.getEntityName())) == null, false);
        GenericHelper helper = this.getEntityHelper(primaryKey.getEntityName());
        GenericValue value = null;
        if (!primaryKey.isPrimaryKey()) {
            throw new IllegalArgumentException("[GenericDelegator.findByPrimaryKey] Passed primary key is not a valid primary key: " + primaryKey);
        }
        this.evalEcaRules("run", "find", primaryKey, ecaEventMap, ecaEventMap == null, false);
        try {
            value = helper.findByPrimaryKey(primaryKey);
        }
        catch (GenericEntityNotFoundException e) {
            value = null;
        }
        if (value != null) {
            value.setDelegator(this);
        }
        this.evalEcaRules("return", "find", primaryKey, ecaEventMap, ecaEventMap == null, false);
        return value;
    }

    public GenericValue findByPrimaryKeyCache(GenericPK primaryKey) throws GenericEntityException {
        Map ecaEventMap;
        this.evalEcaRules("cache-check", "find", primaryKey, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(primaryKey.getEntityName())) == null, false);
        GenericValue value = this.getFromPrimaryKeyCache(primaryKey);
        if (value == null && (value = this.findByPrimaryKey(primaryKey)) != null) {
            this.evalEcaRules("cache-put", "find", primaryKey, ecaEventMap, ecaEventMap == null, false);
            this.putInPrimaryKeyCache(primaryKey, value);
        }
        return value;
    }

    public GenericValue findByPrimaryKey(String entityName, Map fields) throws GenericEntityException {
        return this.findByPrimaryKey(this.makePK(entityName, fields));
    }

    public GenericValue findByPrimaryKeyCache(String entityName, Map fields) throws GenericEntityException {
        return this.findByPrimaryKeyCache(this.makePK(entityName, fields));
    }

    public GenericValue findByPrimaryKeyPartial(GenericPK primaryKey, Set keys) throws GenericEntityException {
        Map ecaEventMap;
        this.evalEcaRules("validate", "find", primaryKey, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(primaryKey.getEntityName())) == null, false);
        GenericHelper helper = this.getEntityHelper(primaryKey.getEntityName());
        GenericValue value = null;
        if (!primaryKey.isPrimaryKey()) {
            throw new IllegalArgumentException("[GenericDelegator.findByPrimaryKey] Passed primary key is not a valid primary key: " + primaryKey);
        }
        this.evalEcaRules("run", "find", primaryKey, ecaEventMap, ecaEventMap == null, false);
        try {
            value = helper.findByPrimaryKeyPartial(primaryKey, keys);
        }
        catch (GenericEntityNotFoundException e) {
            value = null;
        }
        if (value != null) {
            value.setDelegator(this);
        }
        this.evalEcaRules("return", "find", primaryKey, ecaEventMap, ecaEventMap == null, false);
        return value;
    }

    public List findAllByPrimaryKeys(Collection primaryKeys) throws GenericEntityException {
        if (primaryKeys == null) {
            return null;
        }
        LinkedList results = new LinkedList();
        HashMap<String, LinkedList<GenericPK>> pksPerHelper = new HashMap<String, LinkedList<GenericPK>>();
        for (GenericPK curPK : primaryKeys) {
            String helperName = this.getEntityHelperName(curPK.getEntityName());
            LinkedList<GenericPK> pks = (LinkedList<GenericPK>)pksPerHelper.get(helperName);
            if (pks == null) {
                pks = new LinkedList<GenericPK>();
                pksPerHelper.put(helperName, pks);
            }
            pks.add(curPK);
        }
        for (Map.Entry curEntry : pksPerHelper.entrySet()) {
            String helperName = (String)curEntry.getKey();
            GenericHelper helper = GenericHelperFactory.getHelper(helperName);
            List values = helper.findAllByPrimaryKeys((List)curEntry.getValue());
            results.addAll(values);
        }
        return results;
    }

    public List findAllByPrimaryKeysCache(Collection primaryKeys) throws GenericEntityException {
        String helperName;
        if (primaryKeys == null) {
            return null;
        }
        LinkedList<GenericValue> results = new LinkedList<GenericValue>();
        HashMap<String, LinkedList<GenericPK>> pksPerHelper = new HashMap<String, LinkedList<GenericPK>>();
        for (GenericPK curPK : primaryKeys) {
            GenericValue value = this.getFromPrimaryKeyCache(curPK);
            if (value != null) {
                results.add(value);
                continue;
            }
            helperName = this.getEntityHelperName(curPK.getEntityName());
            LinkedList<GenericPK> pks = (LinkedList<GenericPK>)pksPerHelper.get(helperName);
            if (pks == null) {
                pks = new LinkedList<GenericPK>();
                pksPerHelper.put(helperName, pks);
            }
            pks.add(curPK);
        }
        for (Map.Entry curEntry : pksPerHelper.entrySet()) {
            helperName = (String)curEntry.getKey();
            GenericHelper helper = GenericHelperFactory.getHelper(helperName);
            List values = helper.findAllByPrimaryKeys((List)curEntry.getValue());
            this.putAllInPrimaryKeyCache(values);
            results.addAll(values);
        }
        return results;
    }

    public List findAll(String entityName) throws GenericEntityException {
        return this.findByAnd(entityName, new HashMap(), null);
    }

    public List findAll(String entityName, List orderBy) throws GenericEntityException {
        return this.findByAnd(entityName, new HashMap(), orderBy);
    }

    public List findAllCache(String entityName) throws GenericEntityException {
        return this.findAllCache(entityName, null);
    }

    public List findAllCache(String entityName, List orderBy) throws GenericEntityException {
        Map ecaEventMap;
        GenericValue dummyValue = this.makeValue(entityName, null);
        this.evalEcaRules("cache-check", "find", dummyValue, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(entityName)) == null, false);
        List lst = this.getFromAllCache(entityName);
        if (lst == null && (lst = this.findAll(entityName, orderBy)) != null) {
            this.evalEcaRules("cache-put", "find", dummyValue, ecaEventMap, ecaEventMap == null, false);
            this.putInAllCache(entityName, lst);
        }
        return lst;
    }

    public List findByAnd(String entityName, Map fields) throws GenericEntityException {
        return this.findByAnd(entityName, fields, null);
    }

    public List findByOr(String entityName, Map fields) throws GenericEntityException {
        return this.findByOr(entityName, fields, null);
    }

    public List findByAnd(String entityName, Map fields, List orderBy) throws GenericEntityException {
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericValue dummyValue = new GenericValue(modelEntity, fields);
        this.evalEcaRules("validate", "find", dummyValue, null, false, false);
        return this.findByAnd(modelEntity, fields, orderBy);
    }

    public List findByAnd(ModelEntity modelEntity, Map fields, List orderBy) throws GenericEntityException {
        GenericValue dummyValue = new GenericValue(modelEntity);
        Map ecaEventMap = this.getEcaEntityEventMap(modelEntity.getEntityName());
        GenericHelper helper = this.getEntityHelper(modelEntity);
        if (fields != null && !modelEntity.areFields(fields.keySet())) {
            throw new GenericModelException("At least one of the passed fields is not valid: " + fields.keySet().toString());
        }
        this.evalEcaRules("run", "find", dummyValue, ecaEventMap, ecaEventMap == null, false);
        List list = null;
        list = helper.findByAnd(modelEntity, fields, orderBy);
        this.absorbList(list);
        this.evalEcaRules("return", "find", dummyValue, ecaEventMap, ecaEventMap == null, false);
        return list;
    }

    public List findByOr(String entityName, Map fields, List orderBy) throws GenericEntityException {
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericValue dummyValue = new GenericValue(modelEntity);
        Map ecaEventMap = this.getEcaEntityEventMap(modelEntity.getEntityName());
        this.evalEcaRules("validate", "find", dummyValue, null, false, false);
        GenericHelper helper = this.getEntityHelper(entityName);
        if (fields != null && !modelEntity.areFields(fields.keySet())) {
            throw new IllegalArgumentException("[GenericDelegator.findByOr] At least of the passed fields is not valid: " + fields.keySet().toString());
        }
        this.evalEcaRules("run", "find", dummyValue, ecaEventMap, ecaEventMap == null, false);
        List list = null;
        list = helper.findByOr(modelEntity, fields, orderBy);
        this.absorbList(list);
        this.evalEcaRules("return", "find", dummyValue, ecaEventMap, ecaEventMap == null, false);
        return list;
    }

    public List findByAndCache(String entityName, Map fields) throws GenericEntityException {
        return this.findByAndCache(entityName, fields, null);
    }

    public List findByAndCache(String entityName, Map fields, List orderBy) throws GenericEntityException {
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericValue dummyValue = new GenericValue(modelEntity);
        Map ecaEventMap = this.getEcaEntityEventMap(modelEntity.getEntityName());
        this.evalEcaRules("cache-check", "find", dummyValue, null, false, false);
        List lst = this.getFromAndCache(modelEntity, fields);
        if (lst == null && (lst = this.findByAnd(modelEntity, fields, orderBy)) != null) {
            this.evalEcaRules("cache-put", "find", dummyValue, null, false, false);
            this.putInAndCache(modelEntity, fields, lst);
        }
        return lst;
    }

    public List findByAnd(String entityName, List expressions) throws GenericEntityException {
        EntityConditionList ecl = new EntityConditionList(expressions, EntityOperator.AND);
        return this.findByCondition(entityName, ecl, null, null);
    }

    public List findByAnd(String entityName, List expressions, List orderBy) throws GenericEntityException {
        EntityConditionList ecl = new EntityConditionList(expressions, EntityOperator.AND);
        return this.findByCondition(entityName, ecl, null, orderBy);
    }

    public List findByOr(String entityName, List expressions) throws GenericEntityException {
        EntityConditionList ecl = new EntityConditionList(expressions, EntityOperator.OR);
        return this.findByCondition(entityName, ecl, null, null);
    }

    public List findByOr(String entityName, List expressions, List orderBy) throws GenericEntityException {
        EntityConditionList ecl = new EntityConditionList(expressions, EntityOperator.OR);
        return this.findByCondition(entityName, ecl, null, orderBy);
    }

    public List findByLike(String entityName, Map fields) throws GenericEntityException {
        return this.findByLike(entityName, fields, null);
    }

    public List findByLike(String entityName, Map fields, List orderBy) throws GenericEntityException {
        LinkedList<EntityExpr> likeExpressions = new LinkedList<EntityExpr>();
        if (fields != null) {
            for (Map.Entry fieldEntry : fields.entrySet()) {
                likeExpressions.add(new EntityExpr((String)fieldEntry.getKey(), EntityOperator.LIKE, fieldEntry.getValue()));
            }
        }
        EntityConditionList ecl = new EntityConditionList(likeExpressions, EntityOperator.AND);
        return this.findByCondition(entityName, ecl, null, orderBy);
    }

    public List findByCondition(String entityName, EntityCondition entityCondition, Collection fieldsToSelect, List orderBy) throws GenericEntityException {
        Map ecaEventMap;
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericValue dummyValue = new GenericValue(modelEntity);
        this.evalEcaRules("validate", "find", dummyValue, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(entityName)) == null, false);
        if (entityCondition != null) {
            entityCondition.checkCondition(modelEntity);
        }
        this.evalEcaRules("run", "find", dummyValue, ecaEventMap, ecaEventMap == null, false);
        GenericHelper helper = this.getEntityHelper(entityName);
        List list = null;
        list = helper.findByCondition(modelEntity, entityCondition, fieldsToSelect, orderBy);
        this.evalEcaRules("return", "find", dummyValue, ecaEventMap, ecaEventMap == null, false);
        this.absorbList(list);
        return list;
    }

    public EntityListIterator findListIteratorByCondition(String entityName, EntityCondition entityCondition, Collection fieldsToSelect, List orderBy) throws GenericEntityException {
        return this.findListIteratorByCondition(entityName, entityCondition, null, fieldsToSelect, orderBy, null);
    }

    public EntityListIterator findListIteratorByCondition(String entityName, EntityCondition whereEntityCondition, EntityCondition havingEntityCondition, Collection fieldsToSelect, List orderBy, EntityFindOptions findOptions) throws GenericEntityException {
        Map ecaEventMap;
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericValue dummyValue = new GenericValue(modelEntity);
        this.evalEcaRules("validate", "find", dummyValue, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(entityName)) == null, false);
        if (whereEntityCondition != null) {
            whereEntityCondition.checkCondition(modelEntity);
        }
        if (havingEntityCondition != null) {
            havingEntityCondition.checkCondition(modelEntity);
        }
        this.evalEcaRules("run", "find", dummyValue, ecaEventMap, ecaEventMap == null, false);
        GenericHelper helper = this.getEntityHelper(entityName);
        EntityListIterator eli = helper.findListIteratorByCondition(modelEntity, whereEntityCondition, havingEntityCondition, fieldsToSelect, orderBy, findOptions);
        eli.setDelegator(this);
        this.evalEcaRules("return", "find", dummyValue, ecaEventMap, ecaEventMap == null, false);
        return eli;
    }

    public int removeByPrimaryKey(GenericPK primaryKey) throws GenericEntityException {
        return this.removeByPrimaryKey(primaryKey, true);
    }

    public int removeByPrimaryKey(GenericPK primaryKey, boolean doCacheClear) throws GenericEntityException {
        Map ecaEventMap;
        this.evalEcaRules("validate", "remove", primaryKey, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(primaryKey.getEntityName())) == null, false);
        GenericHelper helper = this.getEntityHelper(primaryKey.getEntityName());
        if (doCacheClear) {
            this.evalEcaRules("cache-clear", "remove", primaryKey, ecaEventMap, ecaEventMap == null, false);
            this.clearCacheLine(primaryKey);
        }
        this.evalEcaRules("run", "remove", primaryKey, ecaEventMap, ecaEventMap == null, false);
        int num = helper.removeByPrimaryKey(primaryKey);
        this.evalEcaRules("return", "remove", primaryKey, ecaEventMap, ecaEventMap == null, false);
        return num;
    }

    public int removeValue(GenericValue value) throws GenericEntityException {
        return this.removeValue(value, true);
    }

    public int removeValue(GenericValue value, boolean doCacheClear) throws GenericEntityException {
        Map ecaEventMap;
        this.evalEcaRules("validate", "remove", value, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(value.getEntityName())) == null, false);
        GenericHelper helper = this.getEntityHelper(value.getEntityName());
        if (doCacheClear) {
            this.evalEcaRules("cache-clear", "remove", value, ecaEventMap, ecaEventMap == null, false);
            this.clearCacheLine(value);
        }
        this.evalEcaRules("run", "remove", value, ecaEventMap, ecaEventMap == null, false);
        int num = helper.removeByPrimaryKey(value.getPrimaryKey());
        this.evalEcaRules("return", "remove", value, ecaEventMap, ecaEventMap == null, false);
        return num;
    }

    public int removeByAnd(String entityName, Map fields) throws GenericEntityException {
        return this.removeByAnd(entityName, fields, true);
    }

    public int removeByAnd(String entityName, Map fields, boolean doCacheClear) throws GenericEntityException {
        Map ecaEventMap;
        GenericValue dummyValue = this.makeValue(entityName, fields);
        this.evalEcaRules("validate", "remove", dummyValue, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(entityName)) == null, false);
        ModelEntity modelEntity = this.getModelReader().getModelEntity(entityName);
        GenericHelper helper = this.getEntityHelper(entityName);
        if (doCacheClear) {
            this.evalEcaRules("cache-clear", "remove", dummyValue, ecaEventMap, ecaEventMap == null, false);
            this.clearCacheLine(entityName, fields);
        }
        this.evalEcaRules("run", "remove", dummyValue, ecaEventMap, ecaEventMap == null, false);
        int num = helper.removeByAnd(modelEntity, dummyValue.getAllFields());
        this.evalEcaRules("return", "remove", dummyValue, ecaEventMap, ecaEventMap == null, false);
        return num;
    }

    public List getMultiRelation(GenericValue value, String relationNameOne, String relationNameTwo, List orderBy) throws GenericEntityException {
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation modelRelationOne = modelEntity.getRelation(relationNameOne);
        ModelEntity modelEntityOne = this.getModelEntity(modelRelationOne.getRelEntityName());
        ModelRelation modelRelationTwo = modelEntityOne.getRelation(relationNameTwo);
        ModelEntity modelEntityTwo = this.getModelEntity(modelRelationTwo.getRelEntityName());
        GenericHelper helper = this.getEntityHelper(modelEntity);
        return helper.findByMultiRelation(value, modelRelationOne, modelEntityOne, modelRelationTwo, modelEntityTwo, orderBy);
    }

    public List getMultiRelation(GenericValue value, String relationNameOne, String relationNameTwo) throws GenericEntityException {
        return this.getMultiRelation(value, relationNameOne, relationNameTwo, null);
    }

    public List getRelated(String relationName, GenericValue value) throws GenericEntityException {
        return this.getRelated(relationName, null, null, value);
    }

    public List getRelatedByAnd(String relationName, Map byAndFields, GenericValue value) throws GenericEntityException {
        return this.getRelated(relationName, byAndFields, null, value);
    }

    public List getRelatedOrderBy(String relationName, List orderBy, GenericValue value) throws GenericEntityException {
        return this.getRelated(relationName, null, orderBy, value);
    }

    public List getRelated(String relationName, Map byAndFields, List orderBy, GenericValue value) throws GenericEntityException {
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        HashMap<String, Object> fields = byAndFields == null ? new HashMap<String, Object>() : new HashMap(byAndFields);
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.findByAnd(relation.getRelEntityName(), fields, orderBy);
    }

    public GenericPK getRelatedDummyPK(String relationName, Map byAndFields, GenericValue value) throws GenericEntityException {
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        ModelEntity relatedEntity = this.getModelReader().getModelEntity(relation.getRelEntityName());
        HashMap<String, Object> fields = byAndFields == null ? new HashMap<String, Object>() : new HashMap(byAndFields);
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        GenericPK dummyPK = new GenericPK(relatedEntity, fields);
        dummyPK.setDelegator(this);
        return dummyPK;
    }

    public List getRelatedCache(String relationName, GenericValue value) throws GenericEntityException {
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.findByAndCache(relation.getRelEntityName(), fields, null);
    }

    public GenericValue getRelatedOne(String relationName, GenericValue value) throws GenericEntityException {
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = value.getModelEntity().getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        if (!"one".equals(relation.getType()) && !"one-nofk".equals(relation.getType())) {
            throw new IllegalArgumentException("Relation is not a 'one' or a 'one-nofk' relation: " + relationName + " of entity " + value.getEntityName());
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.findByPrimaryKey(relation.getRelEntityName(), fields);
    }

    public GenericValue getRelatedOneCache(String relationName, GenericValue value) throws GenericEntityException {
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        if (!"one".equals(relation.getType()) && !"one-nofk".equals(relation.getType())) {
            throw new IllegalArgumentException("Relation is not a 'one' or a 'one-nofk' relation: " + relationName + " of entity " + value.getEntityName());
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.findByPrimaryKeyCache(relation.getRelEntityName(), fields);
    }

    public int removeRelated(String relationName, GenericValue value) throws GenericEntityException {
        return this.removeRelated(relationName, value, true);
    }

    public int removeRelated(String relationName, GenericValue value, boolean doCacheClear) throws GenericEntityException {
        ModelEntity modelEntity = value.getModelEntity();
        ModelRelation relation = modelEntity.getRelation(relationName);
        if (relation == null) {
            throw new GenericModelException("Could not find relation for relationName: " + relationName + " for value " + value);
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (int i = 0; i < relation.getKeyMapsSize(); ++i) {
            ModelKeyMap keyMap = relation.getKeyMap(i);
            fields.put(keyMap.getRelFieldName(), value.get(keyMap.getFieldName()));
        }
        return this.removeByAnd(relation.getRelEntityName(), fields, doCacheClear);
    }

    public void refresh(GenericValue value) throws GenericEntityException {
        this.refresh(value, true);
    }

    public void refresh(GenericValue value, boolean doCacheClear) throws GenericEntityException {
        GenericPK pk;
        GenericValue newValue;
        if (doCacheClear) {
            this.clearCacheLine(value);
        }
        if ((newValue = this.findByPrimaryKey(pk = value.getPrimaryKey())) == null) {
            throw new IllegalArgumentException("[GenericDelegator.refresh] could not refresh value: " + value);
        }
        value.fields = newValue.fields;
        value.setDelegator(this);
        value.modified = false;
    }

    public int store(GenericValue value) throws GenericEntityException {
        return this.store(value, true);
    }

    public int store(GenericValue value, boolean doCacheClear) throws GenericEntityException {
        Map ecaEventMap;
        this.evalEcaRules("validate", "store", value, ecaEventMap, (ecaEventMap = this.getEcaEntityEventMap(value.getEntityName())) == null, false);
        GenericHelper helper = this.getEntityHelper(value.getEntityName());
        if (doCacheClear) {
            this.evalEcaRules("cache-clear", "store", value, ecaEventMap, ecaEventMap == null, false);
            this.clearCacheLine(value);
        }
        this.evalEcaRules("run", "store", value, ecaEventMap, ecaEventMap == null, false);
        int retVal = helper.store(value);
        if (value.lockEnabled()) {
            this.refresh(value, doCacheClear);
        }
        this.evalEcaRules("return", "store", value, ecaEventMap, ecaEventMap == null, false);
        return retVal;
    }

    public int storeAll(List values) throws GenericEntityException {
        return this.storeAll(values, true);
    }

    public int storeAll(List values, boolean doCacheClear) throws GenericEntityException {
        if (values == null) {
            return 0;
        }
        HashMap<String, LinkedList<GenericValue>> valuesPerHelper = new HashMap<String, LinkedList<GenericValue>>();
        for (GenericValue value : values) {
            String helperName = this.getEntityHelperName(value.getEntityName());
            LinkedList<GenericValue> helperValues = (LinkedList<GenericValue>)valuesPerHelper.get(helperName);
            if (helperValues == null) {
                helperValues = new LinkedList<GenericValue>();
                valuesPerHelper.put(helperName, helperValues);
            }
            helperValues.add(value);
        }
        boolean beganTransaction = false;
        int numberChanged = 0;
        try {
            if (valuesPerHelper.size() > 1) {
                beganTransaction = TransactionUtil.begin();
            }
            for (Map.Entry curEntry : valuesPerHelper.entrySet()) {
                String helperName = (String)curEntry.getKey();
                GenericHelper helper = GenericHelperFactory.getHelper(helperName);
                if (doCacheClear) {
                    this.clearAllCacheLinesByValue((List)curEntry.getValue());
                }
                numberChanged += helper.storeAll((List)curEntry.getValue());
            }
            TransactionUtil.commit(beganTransaction);
        }
        catch (GenericEntityException e) {
            try {
                TransactionUtil.rollback(beganTransaction);
            }
            catch (GenericEntityException e2) {
                Debug.logError((String)"[GenericDelegator.storeAll] Could not rollback transaction: ", (String)module);
                Debug.logError((Throwable)((Object)e2), (String)module);
            }
            throw e;
        }
        for (GenericValue value : values) {
            if (!value.lockEnabled()) continue;
            this.refresh(value);
        }
        return numberChanged;
    }

    public int removeAll(List dummyPKs) throws GenericEntityException {
        return this.removeAll(dummyPKs, true);
    }

    public int removeAll(List dummyPKs, boolean doCacheClear) throws GenericEntityException {
        if (dummyPKs == null) {
            return 0;
        }
        HashMap<String, LinkedList<GenericEntity>> valuesPerHelper = new HashMap<String, LinkedList<GenericEntity>>();
        for (GenericEntity entity : dummyPKs) {
            String helperName = this.getEntityHelperName(entity.getEntityName());
            LinkedList<GenericEntity> helperValues = (LinkedList<GenericEntity>)valuesPerHelper.get(helperName);
            if (helperValues == null) {
                helperValues = new LinkedList<GenericEntity>();
                valuesPerHelper.put(helperName, helperValues);
            }
            helperValues.add(entity);
        }
        boolean beganTransaction = false;
        int numRemoved = 0;
        try {
            if (valuesPerHelper.size() > 1) {
                beganTransaction = TransactionUtil.begin();
            }
            for (Map.Entry curEntry : valuesPerHelper.entrySet()) {
                String helperName = (String)curEntry.getKey();
                GenericHelper helper = GenericHelperFactory.getHelper(helperName);
                if (doCacheClear) {
                    this.clearAllCacheLinesByDummyPK((List)curEntry.getValue());
                }
                numRemoved += helper.removeAll((List)curEntry.getValue());
            }
            TransactionUtil.commit(beganTransaction);
        }
        catch (GenericEntityException e) {
            try {
                TransactionUtil.rollback(beganTransaction);
            }
            catch (GenericEntityException e2) {
                Debug.logError((String)"[GenericDelegator.removeAll] Could not rollback transaction: ", (String)module);
                Debug.logError((Throwable)((Object)e2), (String)module);
            }
            throw e;
        }
        return numRemoved;
    }

    public void clearAllCaches() {
        this.clearAllCaches(true);
    }

    public void clearAllCaches(boolean distribute) {
        if (this.allCache != null) {
            this.allCache.clear();
        }
        if (this.andCache != null) {
            this.andCache.clear();
        }
        if (this.andCacheFieldSets != null) {
            this.andCacheFieldSets.clear();
        }
        if (this.primaryKeyCache != null) {
            this.primaryKeyCache.clear();
        }
        if (distribute && this.distributedCacheClear != null) {
            this.distributedCacheClear.clearAllCaches();
        }
    }

    public void clearCacheLine(String entityName, Map fields) {
        if (fields == null && this.allCache != null) {
            this.allCache.remove((Object)entityName);
            return;
        }
        ModelEntity entity = this.getModelEntity(entityName);
        if (entity == null) {
            throw new IllegalArgumentException("[GenericDelegator.clearCacheLine] could not find entity for entityName: " + entityName);
        }
        if (entity.getNeverCache()) {
            return;
        }
        GenericPK dummyPK = new GenericPK(entity, fields);
        this.clearCacheLineFlexible(dummyPK);
    }

    public void clearCacheLineFlexible(GenericEntity dummyPK) {
        this.clearCacheLineFlexible(dummyPK, true);
    }

    public void clearCacheLineFlexible(GenericEntity dummyPK, boolean distribute) {
        if (dummyPK != null) {
            if (dummyPK.getModelEntity().getNeverCache()) {
                return;
            }
            if (this.allCache != null) {
                this.allCache.remove((Object)dummyPK.getEntityName());
            }
            if (dummyPK.isPrimaryKey()) {
                if (this.primaryKeyCache != null) {
                    this.primaryKeyCache.remove((Object)dummyPK);
                }
            } else if (dummyPK.size() > 0 && this.andCache != null) {
                this.andCache.remove((Object)dummyPK);
            }
            if (distribute && this.distributedCacheClear != null) {
                this.distributedCacheClear.distributedClearCacheLineFlexible(dummyPK);
            }
        }
    }

    public void clearCacheLine(GenericPK primaryKey) {
        this.clearCacheLine(primaryKey, true);
    }

    public void clearCacheLine(GenericPK primaryKey, boolean distribute) {
        if (primaryKey == null) {
            return;
        }
        if (primaryKey.getModelEntity().getNeverCache()) {
            return;
        }
        if (this.allCache != null) {
            this.allCache.remove((Object)primaryKey.getEntityName());
        }
        if (this.primaryKeyCache != null) {
            this.primaryKeyCache.remove((Object)primaryKey);
        }
        if (distribute && this.distributedCacheClear != null) {
            this.distributedCacheClear.distributedClearCacheLine(primaryKey);
        }
    }

    public void clearCacheLine(GenericValue value) {
        this.clearCacheLine(value, true);
    }

    public void clearCacheLine(GenericValue value, boolean distribute) {
        Set fieldNameSets;
        if (value == null) {
            return;
        }
        if (value.getModelEntity().getNeverCache()) {
            return;
        }
        if (this.allCache != null) {
            this.allCache.remove((Object)value.getEntityName());
        }
        if (this.primaryKeyCache != null) {
            this.primaryKeyCache.remove((Object)value.getPrimaryKey());
        }
        if ((fieldNameSets = (Set)this.andCacheFieldSets.get(value.getEntityName())) != null) {
            for (Set fieldNameSet : fieldNameSets) {
                HashMap<String, Object> originalFieldValues = null;
                if (value.isModified() && value.originalDbValuesAvailable()) {
                    originalFieldValues = new HashMap<String, Object>();
                }
                HashMap<String, Object> fieldValues = new HashMap<String, Object>();
                for (String fieldName : fieldNameSet) {
                    fieldValues.put(fieldName, value.get(fieldName));
                    if (originalFieldValues == null) continue;
                    originalFieldValues.put(fieldName, value.getOriginalDbValue(fieldName));
                }
                GenericPK dummyPK = new GenericPK(value.getModelEntity(), fieldValues);
                this.andCache.remove((Object)dummyPK);
                if (originalFieldValues == null || ((Object)originalFieldValues).equals(fieldValues)) continue;
                GenericPK dummyPKOriginal = new GenericPK(value.getModelEntity(), originalFieldValues);
                this.andCache.remove((Object)dummyPKOriginal);
            }
        }
        if (distribute && this.distributedCacheClear != null) {
            this.distributedCacheClear.distributedClearCacheLine(value);
        }
    }

    public Set getFieldNameSetsCopy(String entityName) {
        Set fieldNameSets = (Set)this.andCacheFieldSets.get(entityName);
        if (fieldNameSets == null) {
            return null;
        }
        TreeSet setsCopy = new TreeSet();
        for (Set fieldNameSet : fieldNameSets) {
            setsCopy.add(new TreeSet(fieldNameSet));
        }
        return setsCopy;
    }

    public void clearAllCacheLinesByDummyPK(Collection dummyPKs) {
        if (dummyPKs == null) {
            return;
        }
        for (GenericEntity entity : dummyPKs) {
            this.clearCacheLineFlexible(entity);
        }
    }

    public void clearAllCacheLinesByValue(Collection values) {
        if (values == null) {
            return;
        }
        for (GenericValue value : values) {
            this.clearCacheLine(value);
        }
    }

    public GenericValue getFromPrimaryKeyCache(GenericPK primaryKey) {
        if (primaryKey == null) {
            return null;
        }
        return (GenericValue)this.primaryKeyCache.get((Object)primaryKey);
    }

    public List getFromAllCache(String entityName) {
        if (entityName == null) {
            return null;
        }
        return (List)this.allCache.get((Object)entityName);
    }

    public List getFromAndCache(String entityName, Map fields) {
        if (entityName == null || fields == null) {
            return null;
        }
        ModelEntity entity = this.getModelEntity(entityName);
        return this.getFromAndCache(entity, fields);
    }

    public List getFromAndCache(ModelEntity entity, Map fields) {
        if (entity == null || fields == null) {
            return null;
        }
        GenericPK tempPK = new GenericPK(entity, fields);
        if (tempPK == null) {
            return null;
        }
        return (List)this.andCache.get((Object)tempPK);
    }

    public void putInPrimaryKeyCache(GenericPK primaryKey, GenericValue value) {
        if (primaryKey == null || value == null) {
            return;
        }
        if (value.getModelEntity().getNeverCache()) {
            Debug.logWarning((String)("Tried to put a value of the " + value.getEntityName() + " entity in the BY PRIMARY KEY cache but this entity has never-cache set to true, not caching."));
            return;
        }
        this.primaryKeyCache.put((Object)primaryKey, (Object)value);
    }

    public void putAllInPrimaryKeyCache(List values) {
        if (values == null) {
            return;
        }
        for (GenericValue value : values) {
            this.putInPrimaryKeyCache(value.getPrimaryKey(), value);
        }
    }

    public void putInAllCache(String entityName, List values) {
        if (entityName == null || values == null) {
            return;
        }
        ModelEntity entity = this.getModelEntity(entityName);
        this.putInAllCache(entity, values);
    }

    public void putInAllCache(ModelEntity entity, List values) {
        if (entity == null || values == null) {
            return;
        }
        if (entity.getNeverCache()) {
            Debug.logWarning((String)("Tried to put values of the " + entity.getEntityName() + " entity in the ALL cache but this entity has never-cache set to true, not caching."));
            return;
        }
        this.allCache.put((Object)entity.getEntityName(), Collections.unmodifiableList(values));
    }

    public void putInAndCache(String entityName, Map fields, List values) {
        if (entityName == null || fields == null || values == null) {
            return;
        }
        ModelEntity entity = this.getModelEntity(entityName);
        this.putInAndCache(entity, fields, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInAndCache(ModelEntity entity, Map fields, List values) {
        if (entity == null || fields == null || values == null) {
            return;
        }
        if (entity.getNeverCache()) {
            Debug.logWarning((String)("Tried to put values of the " + entity.getEntityName() + " entity in the BY AND cache but this entity has never-cache set to true, not caching."));
            return;
        }
        GenericPK tempPK = new GenericPK(entity, fields);
        if (tempPK == null) {
            return;
        }
        this.andCache.put((Object)tempPK, Collections.unmodifiableList(values));
        HashSet fieldNameSets = (HashSet)this.andCacheFieldSets.get(entity.getEntityName());
        if (fieldNameSets == null) {
            GenericDelegator genericDelegator = this;
            synchronized (genericDelegator) {
                fieldNameSets = (Set)this.andCacheFieldSets.get(entity.getEntityName());
                if (fieldNameSets == null) {
                    fieldNameSets = new HashSet();
                    this.andCacheFieldSets.put(entity.getEntityName(), fieldNameSets);
                }
            }
        }
        fieldNameSets.add(new HashSet(fields.keySet()));
    }

    public List readXmlDocument(URL url) throws SAXException, ParserConfigurationException, IOException {
        if (url == null) {
            return null;
        }
        return this.makeValues(UtilXml.readXmlDocument((URL)url, (boolean)false));
    }

    public List makeValues(Document document) {
        if (document == null) {
            return null;
        }
        LinkedList<GenericValue> values = new LinkedList<GenericValue>();
        Element docElement = document.getDocumentElement();
        if (docElement == null) {
            return null;
        }
        if (!"entity-engine-xml".equals(docElement.getTagName())) {
            Debug.logError((String)"[GenericDelegator.makeValues] Root node was not <entity-engine-xml>", (String)module);
            throw new IllegalArgumentException("Root node was not <entity-engine-xml>");
        }
        docElement.normalize();
        Node curChild = docElement.getFirstChild();
        if (curChild != null) {
            do {
                Element element;
                GenericValue value;
                if (curChild.getNodeType() != 1 || (value = this.makeValue(element = (Element)curChild)) == null) continue;
                values.add(value);
            } while ((curChild = curChild.getNextSibling()) != null);
        } else {
            Debug.logWarning((String)"[GenericDelegator.makeValues] No child nodes found in document.", (String)module);
        }
        return values;
    }

    public GenericPK makePK(Element element) {
        GenericValue value = this.makeValue(element);
        return value.getPrimaryKey();
    }

    public GenericValue makeValue(Element element) {
        if (element == null) {
            return null;
        }
        String entityName = element.getTagName();
        if (entityName.indexOf(45) > 0) {
            entityName = entityName.substring(entityName.indexOf(45) + 1);
        }
        if (entityName.indexOf(58) > 0) {
            entityName = entityName.substring(entityName.indexOf(58) + 1);
        }
        GenericValue value = this.makeValue(entityName, null);
        ModelEntity modelEntity = value.getModelEntity();
        Iterator modelFields = modelEntity.getFieldsIterator();
        while (modelFields.hasNext()) {
            ModelField modelField = (ModelField)modelFields.next();
            String name = modelField.getName();
            String attr = element.getAttribute(name);
            if (attr != null && attr.length() > 0) {
                value.setString(name, attr);
                continue;
            }
            Element subElement = UtilXml.firstChildElement((Element)element, (String)name);
            if (subElement == null) continue;
            value.setString(name, UtilXml.elementValue((Element)subElement));
        }
        return value;
    }

    protected Map getEcaEntityEventMap(String entityName) {
        if (this.entityEcaHandler == null) {
            return null;
        }
        Map ecaEventMap = this.entityEcaHandler.getEntityEventMap(entityName);
        return ecaEventMap;
    }

    protected void evalEcaRules(String event, String currentOperation, GenericEntity value, Map eventMap, boolean noEventMapFound, boolean isError) throws GenericEntityException {
        if (noEventMapFound) {
            return;
        }
        if (this.entityEcaHandler == null) {
            return;
        }
        this.entityEcaHandler.evalRules(currentOperation, eventMap, event, value, isError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextSeqId(String seqName) {
        if (this.sequencer == null) {
            GenericDelegator genericDelegator = this;
            synchronized (genericDelegator) {
                if (this.sequencer == null) {
                    String helperName = this.getEntityHelperName("SequenceValueItem");
                    ModelEntity seqEntity = this.getModelEntity("SequenceValueItem");
                    this.sequencer = new SequenceUtil(helperName, seqEntity, "seqName", "seqId");
                }
            }
        }
        if (this.sequencer != null) {
            return this.sequencer.getNextSeqId(seqName);
        }
        return null;
    }

    public void setSequencer(SequenceUtil sequencer) {
        this.sequencer = sequencer;
    }

    public void refreshSequencer() {
        this.sequencer = null;
    }

    protected void absorbList(List lst) {
        if (lst == null) {
            return;
        }
        for (GenericValue value : lst) {
            value.setDelegator(this);
        }
    }

    public UtilCache getPrimaryKeyCache() {
        return this.primaryKeyCache;
    }

    public UtilCache getAndCache() {
        return this.andCache;
    }

    public UtilCache getAllCache() {
        return this.allCache;
    }
}

