/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.model;

import java.util.ArrayList;
import java.util.List;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.model.ModelFieldTypeReader;
import org.ofbiz.core.entity.model.ModelUtil;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModelField {
    protected String name = "";
    protected String type = "";
    protected String colName = "";
    protected boolean isPk = false;
    protected List<String> validators = new ArrayList<String>();

    public ModelField() {
    }

    public ModelField(Element fieldElement) {
        this.type = UtilXml.checkEmpty((String)fieldElement.getAttribute("type"));
        this.name = UtilXml.checkEmpty((String)fieldElement.getAttribute("name"));
        this.colName = UtilXml.checkEmpty((String)fieldElement.getAttribute("col-name"), (String)ModelUtil.javaNameToDbName(UtilXml.checkEmpty((String)this.name)));
        this.isPk = false;
        NodeList validateList = fieldElement.getElementsByTagName("validate");
        for (int i = 0; i < validateList.getLength(); ++i) {
            Element element = (Element)validateList.item(i);
            this.validators.add(UtilXml.checkEmpty((String)element.getAttribute("name")));
        }
    }

    public ModelField(DatabaseUtil.ColumnCheckInfo ccInfo, ModelFieldTypeReader modelFieldTypeReader) {
        this.colName = ccInfo.columnName.toUpperCase();
        this.name = ModelUtil.dbNameToVarName(this.colName);
        this.type = ModelUtil.induceFieldType(ccInfo.typeName, ccInfo.columnSize, ccInfo.decimalDigits, modelFieldTypeReader);
        this.isPk = "NO".equals(ccInfo.isNullable);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getColName() {
        return this.colName;
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public boolean getIsPk() {
        return this.isPk;
    }

    public void setIsPk(boolean isPk) {
        this.isPk = isPk;
    }

    public String getValidator(int index) {
        return this.validators.get(index);
    }

    public int getValidatorsSize() {
        return this.validators.size();
    }

    public void addValidator(String validator) {
        this.validators.add(validator);
    }

    public String removeValidator(int index) {
        return this.validators.remove(index);
    }
}

