/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.util.UtilValidate;

public class GenericValue
extends GenericEntity {
    public transient Map<String, List<GenericValue>> relatedCache = null;
    public transient Map<String, GenericValue> relatedOneCache = null;
    protected Map<String, Object> originalDbValues = null;

    public GenericValue(ModelEntity modelEntity) {
        super(modelEntity);
    }

    public GenericValue(ModelEntity modelEntity, Map<String, ?> fields) {
        super(modelEntity, fields);
    }

    public GenericValue(GenericValue value) {
        super(value);
    }

    public GenericValue(GenericPK primaryKey) {
        super(primaryKey);
    }

    public GenericValue create() throws GenericEntityException {
        return this.getDelegator().create(this);
    }

    public void store() throws GenericEntityException {
        this.getDelegator().store(this);
    }

    public void remove() throws GenericEntityException {
        this.getDelegator().removeValue(this);
    }

    public void refresh() throws GenericEntityException {
        this.getDelegator().refresh(this);
    }

    public boolean originalDbValuesAvailable() {
        return this.originalDbValues != null;
    }

    public Object getOriginalDbValue(String name) {
        if (this.getModelEntity().getField(name) == null) {
            throw new IllegalArgumentException("[GenericEntity.get] \"" + name + "\" is not a field of " + this.entityName);
        }
        return this.originalDbValues.get(name);
    }

    public void copyOriginalDbValues() {
        this.originalDbValues = new HashMap<String, Object>(this.fields);
    }

    public List<GenericValue> getRelated(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelated(relationName, this);
    }

    public List<GenericValue> getRelated(String relationName, Map<String, ?> byAndFields, List<String> orderBy) throws GenericEntityException {
        return this.getDelegator().getRelated(relationName, byAndFields, orderBy, this);
    }

    public List<GenericValue> getRelatedCache(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelatedCache(relationName, this);
    }

    public List<GenericValue> getRelatedMulti(String relationNameOne, String relationNameTwo, List<String> orderBy) throws GenericEntityException {
        return this.getDelegator().getMultiRelation(this, relationNameOne, relationNameTwo, orderBy);
    }

    public List<GenericValue> getRelatedMulti(String relationNameOne, String relationNameTwo) throws GenericEntityException {
        return this.getDelegator().getMultiRelation(this, relationNameOne, relationNameTwo, null);
    }

    public List<GenericValue> getRelatedCache(String relationName, Map<String, ?> byAndFields, List<String> orderBy) throws GenericEntityException {
        List<GenericValue> col = this.getRelatedCache(relationName);
        if (byAndFields != null) {
            col = EntityUtil.filterByAnd(col, byAndFields);
        }
        if (UtilValidate.isNotEmpty(orderBy)) {
            col = EntityUtil.orderBy(col, orderBy);
        }
        return col;
    }

    public List<GenericValue> getRelatedEmbeddedCache(String relationName) throws GenericEntityException {
        List<GenericValue> col;
        if (this.relatedCache == null) {
            this.relatedCache = new Hashtable<String, List<GenericValue>>();
        }
        if ((col = this.relatedCache.get(relationName)) == null) {
            col = this.getRelated(relationName);
            this.relatedCache.put(relationName, col);
        }
        return col;
    }

    public List<GenericValue> getRelatedEmbeddedCache(String relationName, Map<String, ?> byAndFields, List<String> orderBy) throws GenericEntityException {
        List<GenericValue> col = this.getRelatedEmbeddedCache(relationName);
        if (byAndFields != null) {
            col = EntityUtil.filterByAnd(col, byAndFields);
        }
        if (UtilValidate.isNotEmpty(orderBy)) {
            col = EntityUtil.orderBy(col, orderBy);
        }
        return col;
    }

    public GenericValue getRelatedOne(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelatedOne(relationName, this);
    }

    public GenericValue getRelatedOneCache(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelatedOneCache(relationName, this);
    }

    public GenericValue getRelatedOneEmbeddedCache(String relationName) throws GenericEntityException {
        GenericValue value;
        if (this.relatedOneCache == null) {
            this.relatedOneCache = new Hashtable<String, GenericValue>();
        }
        if ((value = this.relatedOneCache.get(relationName)) == null && (value = this.getRelatedOne(relationName)) != null) {
            this.relatedOneCache.put(relationName, value);
        }
        return value;
    }

    public List<GenericValue> getRelatedByAnd(String relationName, Map<String, ?> fields) throws GenericEntityException {
        return this.getDelegator().getRelatedByAnd(relationName, fields, this);
    }

    public List<GenericValue> getRelatedByAndCache(String relationName, Map<String, ?> fields) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getDelegator().getRelatedCache(relationName, this), fields);
    }

    public List<GenericValue> getRelatedByAndEmbeddedCache(String relationName, Map<String, ?> fields) throws GenericEntityException {
        return EntityUtil.filterByAnd(this.getRelatedEmbeddedCache(relationName), fields);
    }

    public List<GenericValue> getRelatedOrderBy(String relationName, List<String> orderBy) throws GenericEntityException {
        return this.getDelegator().getRelatedOrderBy(relationName, orderBy, this);
    }

    public List<GenericValue> getRelatedOrderByCache(String relationName, List<String> orderBy) throws GenericEntityException {
        return EntityUtil.orderBy(this.getDelegator().getRelatedCache(relationName, this), orderBy);
    }

    public List<GenericValue> getRelatedOrderByEmbeddedCache(String relationName, List<String> orderBy) throws GenericEntityException {
        return EntityUtil.orderBy(this.getRelatedEmbeddedCache(relationName), orderBy);
    }

    public void removeRelated(String relationName) throws GenericEntityException {
        this.getDelegator().removeRelated(relationName, this);
    }

    public GenericPK getRelatedDummyPK(String relationName) throws GenericEntityException {
        return this.getDelegator().getRelatedDummyPK(relationName, null, this);
    }

    public GenericPK getRelatedDummyPK(String relationName, Map<String, ?> byAndFields) throws GenericEntityException {
        return this.getDelegator().getRelatedDummyPK(relationName, byAndFields, this);
    }

    @Override
    public Object clone() {
        GenericValue newEntity = new GenericValue(this);
        newEntity.setDelegator(this.internalDelegator);
        return newEntity;
    }
}

