/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.MapComparator;
import org.ofbiz.core.util.StringUtil;

public class UtilMisc {
    public static <T> Iterator<T> toIterator(Collection<T> col) {
        if (col == null) {
            return null;
        }
        return col.iterator();
    }

    public static Map<String, Object> toMap(String name1, Object value1) {
        return new SimpleMap(name1, value1);
    }

    public static Map<String, Object> toMap(String name1, Object value1, String name2, Object value2) {
        return new SimpleMap(name1, value1, name2, value2);
    }

    public static Map<String, Object> toMap(String name1, Object value1, String name2, Object value2, String name3, Object value3) {
        return new SimpleMap(name1, value1, name2, value2, name3, value3);
    }

    public static Map<String, Object> toMap(String name1, Object value1, String name2, Object value2, String name3, Object value3, String name4, Object value4) {
        return new SimpleMap(name1, value1, name2, value2, name3, value3, name4, value4);
    }

    public static Map<String, Object> toMap(String name1, Object value1, String name2, Object value2, String name3, Object value3, String name4, Object value4, String name5, Object value5) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(name1, value1);
        fields.put(name2, value2);
        fields.put(name3, value3);
        fields.put(name4, value4);
        fields.put(name5, value5);
        return fields;
    }

    public static Map<String, Object> toMap(String name1, Object value1, String name2, Object value2, String name3, Object value3, String name4, Object value4, String name5, Object value5, String name6, Object value6) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put(name1, value1);
        fields.put(name2, value2);
        fields.put(name3, value3);
        fields.put(name4, value4);
        fields.put(name5, value5);
        fields.put(name6, value6);
        return fields;
    }

    public static <K, V> List<Map<K, V>> sortMaps(List<Map<K, V>> listOfMaps, List<? extends K> sortKeys) {
        if (listOfMaps == null || sortKeys == null) {
            return null;
        }
        LinkedList<Map<K, V>> toSort = new LinkedList<Map<K, V>>(listOfMaps);
        try {
            MapComparator<? extends K> mc = new MapComparator<K>(sortKeys);
            Collections.sort(toSort, mc);
        }
        catch (Exception e) {
            Debug.logError(e, "Problems sorting list of maps; returning null.");
            return null;
        }
        return toSort;
    }

    public static <T> List<T> toList(T obj1) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(obj1);
        return list;
    }

    public static <T> List<T> toList(T obj1, T obj2) {
        ArrayList<T> list = new ArrayList<T>(2);
        list.add(obj1);
        list.add(obj2);
        return list;
    }

    public static <T> List<T> toList(T obj1, T obj2, T obj3) {
        ArrayList<T> list = new ArrayList<T>(3);
        list.add(obj1);
        list.add(obj2);
        list.add(obj3);
        return list;
    }

    public static <T> List<T> toList(T obj1, T obj2, T obj3, T obj4) {
        ArrayList<T> list = new ArrayList<T>(4);
        list.add(obj1);
        list.add(obj2);
        list.add(obj3);
        list.add(obj4);
        return list;
    }

    public static <T> List<T> toList(T obj1, T obj2, T obj3, T obj4, T obj5) {
        ArrayList<T> list = new ArrayList<T>(5);
        list.add(obj1);
        list.add(obj2);
        list.add(obj3);
        list.add(obj4);
        list.add(obj5);
        return list;
    }

    public static <T> List<T> toList(T obj1, T obj2, T obj3, T obj4, T obj5, T obj6) {
        ArrayList<T> list = new ArrayList<T>(6);
        list.add(obj1);
        list.add(obj2);
        list.add(obj3);
        list.add(obj4);
        list.add(obj5);
        list.add(obj6);
        return list;
    }

    public static <T> List<T> toList(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayList<T>(collection);
    }

    public static Locale parseLocale(String localeString) {
        if (localeString == null || localeString.length() == 0) {
            return null;
        }
        List<String> splitList = StringUtil.split(localeString, "_");
        if (splitList.size() != 2) {
            return null;
        }
        String language = splitList.get(0);
        String country = splitList.get(1);
        return new Locale(language, country);
    }

    protected static class SimpleMap
    implements Map<String, Object>,
    Serializable {
        protected Map<String, Object> realMapIfNeeded = null;
        String[] names;
        Object[] values;

        public SimpleMap() {
            this.names = new String[0];
            this.values = new Object[0];
        }

        public SimpleMap(String name1, Object value1) {
            this.names = new String[1];
            this.values = new Object[1];
            this.names[0] = name1;
            this.values[0] = value1;
        }

        public SimpleMap(String name1, Object value1, String name2, Object value2) {
            this.names = new String[2];
            this.values = new Object[2];
            this.names[0] = name1;
            this.values[0] = value1;
            this.names[1] = name2;
            this.values[1] = value2;
        }

        public SimpleMap(String name1, Object value1, String name2, Object value2, String name3, Object value3) {
            this.names = new String[3];
            this.values = new Object[3];
            this.names[0] = name1;
            this.values[0] = value1;
            this.names[1] = name2;
            this.values[1] = value2;
            this.names[2] = name3;
            this.values[2] = value3;
        }

        public SimpleMap(String name1, Object value1, String name2, Object value2, String name3, Object value3, String name4, Object value4) {
            this.names = new String[4];
            this.values = new Object[4];
            this.names[0] = name1;
            this.values[0] = value1;
            this.names[1] = name2;
            this.values[1] = value2;
            this.names[2] = name3;
            this.values[2] = value3;
            this.names[3] = name4;
            this.values[3] = value4;
        }

        protected void makeRealMap() {
            this.realMapIfNeeded = new HashMap<String, Object>();
            for (int i = 0; i < this.names.length; ++i) {
                this.realMapIfNeeded.put(this.names[i], this.values[i]);
            }
            this.names = null;
            this.values = null;
        }

        @Override
        public void clear() {
            if (this.realMapIfNeeded != null) {
                this.realMapIfNeeded.clear();
            } else {
                this.realMapIfNeeded = new HashMap<String, Object>();
                this.names = null;
                this.values = null;
            }
        }

        @Override
        public boolean containsKey(Object obj) {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.containsKey(obj);
            }
            for (String name : this.names) {
                if (obj == null && name == null) {
                    return true;
                }
                if (name == null || !name.equals(obj)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsValue(Object obj) {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.containsValue(obj);
            }
            for (int i = 0; i < this.names.length; ++i) {
                if (obj == null && this.values[i] == null) {
                    return true;
                }
                if (this.values[i] == null || !this.values[i].equals(obj)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.entrySet();
            }
            this.makeRealMap();
            return this.realMapIfNeeded.entrySet();
        }

        @Override
        public Object get(Object obj) {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.get(obj);
            }
            for (int i = 0; i < this.names.length; ++i) {
                if (obj == null && this.names[i] == null) {
                    return this.values[i];
                }
                if (this.names[i] == null || !this.names[i].equals(obj)) continue;
                return this.values[i];
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.isEmpty();
            }
            return this.names.length == 0;
        }

        @Override
        public Set<String> keySet() {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.keySet();
            }
            this.makeRealMap();
            return this.realMapIfNeeded.keySet();
        }

        @Override
        public Object put(String obj, Object obj1) {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.put(obj, obj1);
            }
            this.makeRealMap();
            return this.realMapIfNeeded.put(obj, obj1);
        }

        @Override
        public void putAll(Map<? extends String, ?> map) {
            if (this.realMapIfNeeded != null) {
                this.realMapIfNeeded.putAll(map);
            } else {
                this.makeRealMap();
                this.realMapIfNeeded.putAll(map);
            }
        }

        @Override
        public Object remove(Object obj) {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.remove(obj);
            }
            this.makeRealMap();
            return this.realMapIfNeeded.remove(obj);
        }

        @Override
        public int size() {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.size();
            }
            return this.names.length;
        }

        @Override
        public Collection<Object> values() {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.values();
            }
            this.makeRealMap();
            return this.realMapIfNeeded.values();
        }

        public String toString() {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.toString();
            }
            StringBuilder outString = new StringBuilder("{");
            for (int i = 0; i < this.names.length; ++i) {
                if (i > 0) {
                    outString.append(',');
                }
                outString.append('{');
                outString.append(this.names[i]);
                outString.append(',');
                outString.append(this.values[i]);
                outString.append('}');
            }
            outString.append('}');
            return outString.toString();
        }

        @Override
        public int hashCode() {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.hashCode();
            }
            int hashCode = 0;
            for (int i = 0; i < this.names.length; ++i) {
                int tempNum = (this.names[i] == null ? 0 : this.names[i].hashCode()) ^ (this.values[i] == null ? 0 : this.values[i].hashCode());
                hashCode += tempNum;
            }
            return hashCode;
        }

        @Override
        public boolean equals(Object obj) {
            if (this.realMapIfNeeded != null) {
                return this.realMapIfNeeded.equals(obj);
            }
            Map mapObj = (Map)obj;
            if (mapObj.size() != this.names.length) {
                return false;
            }
            for (int i = 0; i < this.names.length; ++i) {
                if (!mapObj.containsKey(this.names[i])) {
                    return false;
                }
                Object mapValue = mapObj.get(this.names[i]);
                if (!(mapValue == null ? this.values[i] != null : !mapValue.equals(this.values[i]))) continue;
                return false;
            }
            return true;
        }
    }
}

