/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.util.ObjectType;

public class MapComparator<K>
implements Comparator<Map<K, ?>> {
    private List<? extends K> keys;

    public MapComparator(List<? extends K> keys) {
        this.keys = keys;
    }

    @Override
    public int compare(Map<K, ?> map1, Map<K, ?> map2) {
        if (this.keys == null || this.keys.size() < 1) {
            throw new IllegalArgumentException("No sort fields defined");
        }
        for (K key : this.keys) {
            if (this.testValue(map1, key) && !this.testValue(map2, key)) {
                return -1;
            }
            if (!this.testValue(map1, key) && this.testValue(map2, key)) {
                return 1;
            }
            if (!this.testValue(map1, key) && !this.testValue(map2, key)) continue;
            Object o1 = map1.get(key);
            Object o2 = map2.get(key);
            try {
                Comparable<Double> d2;
                Comparable<Double> d1;
                if (o1.equals(o2)) continue;
                if (ObjectType.instanceOf(o1, "java.lang.String")) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    if (s1.equals(s2)) continue;
                    return s1.compareTo(s2);
                }
                if (ObjectType.instanceOf(o1, "java.lang.Integer")) {
                    Integer i1 = (Integer)o1;
                    Integer i2 = (Integer)o2;
                    if (i1.equals(i2)) continue;
                    return i1.compareTo(i2);
                }
                if (ObjectType.instanceOf(o1, "java.lang.Double")) {
                    d1 = (Double)o1;
                    d2 = (Double)o2;
                    if (((Double)d1).equals(d2)) continue;
                    return ((Double)d1).compareTo((Double)d2);
                }
                if (ObjectType.instanceOf(o1, "java.lang.Float")) {
                    Float f1 = (Float)o1;
                    Float f2 = (Float)o2;
                    if (f1.equals(f2)) continue;
                    return f1.compareTo(f2);
                }
                if (ObjectType.instanceOf(o1, "java.sql.Timestamp")) {
                    Timestamp t1 = (Timestamp)o1;
                    Timestamp t2 = (Timestamp)o2;
                    if (t1.equals(t2)) continue;
                    return t1.compareTo(t2);
                }
                if (!ObjectType.instanceOf(o1, "java.util.Date") || ((Date)(d1 = (Date)o1)).equals(d2 = (Date)o2)) continue;
                return ((Date)d1).compareTo((Date)d2);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj.equals(this);
    }

    private boolean testValue(Map<K, ?> map, K key) {
        if (!map.containsKey(key)) {
            return false;
        }
        return map.get(key) != null;
    }
}

