/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import org.ofbiz.core.util.StringUtil;

public class UtilFormatOut {
    static DecimalFormat priceDecimalFormat = new DecimalFormat("#,##0.00");
    static DecimalFormat percentageDecimalFormat = new DecimalFormat("##0.##%");
    static DecimalFormat quantityDecimalFormat = new DecimalFormat("#,##0.###");

    public static String formatPrice(Double price) {
        if (price == null) {
            return "";
        }
        return UtilFormatOut.formatPrice((double)price);
    }

    public static String formatPrice(double price) {
        return priceDecimalFormat.format(price);
    }

    public static String formatPercentage(Double percentage) {
        if (percentage == null) {
            return "";
        }
        return UtilFormatOut.formatPercentage((double)percentage);
    }

    public static String formatPercentage(double percentage) {
        return percentageDecimalFormat.format(percentage);
    }

    public static String formatQuantity(Long quantity) {
        if (quantity == null) {
            return "";
        }
        return UtilFormatOut.formatQuantity(quantity.doubleValue());
    }

    public static String formatQuantity(long quantity) {
        return UtilFormatOut.formatQuantity((double)quantity);
    }

    public static String formatQuantity(Integer quantity) {
        if (quantity == null) {
            return "";
        }
        return UtilFormatOut.formatQuantity(quantity.doubleValue());
    }

    public static String formatQuantity(int quantity) {
        return UtilFormatOut.formatQuantity((double)quantity);
    }

    public static String formatQuantity(Float quantity) {
        if (quantity == null) {
            return "";
        }
        return UtilFormatOut.formatQuantity(quantity.doubleValue());
    }

    public static String formatQuantity(float quantity) {
        return UtilFormatOut.formatQuantity((double)quantity);
    }

    public static String formatQuantity(Double quantity) {
        if (quantity == null) {
            return "";
        }
        return UtilFormatOut.formatQuantity((double)quantity);
    }

    public static String formatQuantity(double quantity) {
        return quantityDecimalFormat.format(quantity);
    }

    public static String formatDate(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        DateFormat df = DateFormat.getDateTimeInstance(1, 0);
        Timestamp date = timestamp;
        return df.format(date);
    }

    public static String makeString(Object obj1) {
        if (obj1 != null) {
            return obj1.toString();
        }
        return "";
    }

    public static String checkNull(String string1) {
        if (string1 != null) {
            return string1;
        }
        return "";
    }

    public static String checkNull(String string1, String string2) {
        if (string1 != null) {
            return string1;
        }
        if (string2 != null) {
            return string2;
        }
        return "";
    }

    public static String checkNull(String string1, String string2, String string3) {
        if (string1 != null) {
            return string1;
        }
        if (string2 != null) {
            return string2;
        }
        if (string3 != null) {
            return string3;
        }
        return "";
    }

    public static String checkNull(String string1, String string2, String string3, String string4) {
        if (string1 != null) {
            return string1;
        }
        if (string2 != null) {
            return string2;
        }
        if (string3 != null) {
            return string3;
        }
        if (string4 != null) {
            return string4;
        }
        return "";
    }

    public static String ifNotEmpty(String base, String pre, String post) {
        if (base != null && base.length() > 0) {
            return pre + base + post;
        }
        return "";
    }

    public static String checkEmpty(String string1, String string2) {
        if (string1 != null && string1.length() > 0) {
            return string1;
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return "";
    }

    public static String checkEmpty(String string1, String string2, String string3) {
        if (string1 != null && string1.length() > 0) {
            return string1;
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        if (string3 != null && string3.length() > 0) {
            return string3;
        }
        return "";
    }

    public static String encodeQuery(String query) {
        String retString = UtilFormatOut.replaceString(query, "%", "%25");
        retString = UtilFormatOut.replaceString(retString, " ", "%20");
        return retString;
    }

    public static String encodeQueryValue(String query) {
        String retString = UtilFormatOut.replaceString(query, "%", "%25");
        retString = UtilFormatOut.replaceString(retString, " ", "%20");
        retString = UtilFormatOut.replaceString(retString, "&", "%26");
        retString = UtilFormatOut.replaceString(retString, "?", "%3F");
        retString = UtilFormatOut.replaceString(retString, "=", "%3D");
        return retString;
    }

    public static String replaceString(String mainString, String oldString, String newString) {
        return StringUtil.replaceString(mainString, oldString, newString);
    }

    public static String decodeQueryValue(String query) {
        String retString = UtilFormatOut.replaceString(query, "%25", "%");
        retString = UtilFormatOut.replaceString(retString, "%20", " ");
        retString = UtilFormatOut.replaceString(retString, "%26", "&");
        retString = UtilFormatOut.replaceString(retString, "%3F", "?");
        retString = UtilFormatOut.replaceString(retString, "%3D", "=");
        return retString;
    }

    public static String encodeXmlValue(String inString) {
        String retString = inString;
        retString = StringUtil.replaceString(retString, "&", "&amp;");
        retString = StringUtil.replaceString(retString, "<", "&lt;");
        retString = StringUtil.replaceString(retString, ">", "&gt;");
        retString = StringUtil.replaceString(retString, "\"", "&quot;");
        retString = StringUtil.replaceString(retString, "'", "&apos;");
        return retString;
    }
}

