/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ofbiz.core.util.CachedClassLoader;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.GeneralException;
import org.ofbiz.core.util.UtilMisc;

public class ObjectType {
    public static final String module = ObjectType.class.getName();
    protected static Map<String, Class<?>> classCache = new HashMap();
    public static final String LANG_PACKAGE = "java.lang.";
    public static final String SQL_PACKAGE = "java.sql.";

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> theClass = CachedClassLoader.globalClassNameClassMap.get(className);
        if (theClass != null) {
            return theClass;
        }
        return ObjectType.loadClass(className, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class<?> loadClass(String className, ClassLoader loader) throws ClassNotFoundException {
        Class<?> theClass = CachedClassLoader.globalClassNameClassMap.get(className);
        if (theClass != null) {
            return theClass;
        }
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        try {
            return loader.loadClass(className);
        }
        catch (Exception e) {
            theClass = classCache.get(className);
            if (theClass != null) return theClass;
            Class<ObjectType> clazz = ObjectType.class;
            synchronized (ObjectType.class) {
                theClass = classCache.get(className);
                if (theClass != null) return theClass;
                theClass = Class.forName(className);
                if (theClass == null) return theClass;
                if (Debug.verboseOn()) {
                    Debug.logVerbose("Loaded Class: " + theClass.getName(), module);
                }
                classCache.put(className, theClass);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return theClass;
            }
        }
    }

    public static Object getInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = ObjectType.loadClass(className);
        Object o = c.newInstance();
        if (Debug.verboseOn()) {
            Debug.logVerbose("Instantiated object: " + o.toString(), module);
        }
        return o;
    }

    public static boolean interfaceOf(Object obj, String interfaceName) throws ClassNotFoundException {
        Class<?> interfaceClass = ObjectType.loadClass(interfaceName);
        return ObjectType.interfaceOf(obj, interfaceClass);
    }

    public static boolean interfaceOf(Object obj, Object interfaceObject) {
        Class<?> interfaceClass = interfaceObject.getClass();
        return ObjectType.interfaceOf(obj, interfaceClass);
    }

    public static boolean interfaceOf(Object obj, Class<?> interfaceClass) {
        for (Class<?> objectClass = obj.getClass(); objectClass != null; objectClass = objectClass.getSuperclass()) {
            Class<?>[] ifaces;
            for (Class<?> iface : ifaces = objectClass.getInterfaces()) {
                if (iface != interfaceClass) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOrSubOf(Object obj, String parentName) throws ClassNotFoundException {
        Class<?> parentClass = ObjectType.loadClass(parentName);
        return ObjectType.isOrSubOf(obj, parentClass);
    }

    public static boolean isOrSubOf(Object obj, Object parentObject) {
        Class<?> parentClass = parentObject.getClass();
        return ObjectType.isOrSubOf(obj, parentClass);
    }

    public static boolean isOrSubOf(Object obj, Class<?> parentClass) {
        for (Class<?> objectClass = obj.getClass(); objectClass != null; objectClass = objectClass.getSuperclass()) {
            if (objectClass != parentClass) continue;
            return true;
        }
        return false;
    }

    public static boolean instanceOf(Object obj, Object typeObject) {
        Class<?> typeClass = typeObject.getClass();
        return ObjectType.instanceOf(obj, typeClass);
    }

    public static boolean instanceOf(Object obj, String typeName) {
        return ObjectType.instanceOf(obj, typeName, null);
    }

    public static boolean instanceOf(Object obj, String typeName, ClassLoader loader) {
        Class<?> infoClass = null;
        try {
            infoClass = ObjectType.loadClass(typeName, loader);
        }
        catch (SecurityException se1) {
            throw new IllegalArgumentException("Problems with classloader: security exception (" + se1.getMessage() + ")");
        }
        catch (ClassNotFoundException e1) {
            try {
                infoClass = ObjectType.loadClass(LANG_PACKAGE + typeName, loader);
            }
            catch (SecurityException se2) {
                throw new IllegalArgumentException("Problems with classloader: security exception (" + se2.getMessage() + ")");
            }
            catch (ClassNotFoundException e2) {
                try {
                    infoClass = ObjectType.loadClass(SQL_PACKAGE + typeName, loader);
                }
                catch (SecurityException se3) {
                    throw new IllegalArgumentException("Problems with classloader: security exception (" + se3.getMessage() + ")");
                }
                catch (ClassNotFoundException e3) {
                    throw new IllegalArgumentException("Cannot find and load the class of type: " + typeName + " or of type: " + LANG_PACKAGE + typeName + " or of type: " + SQL_PACKAGE + typeName + ":  (" + e3.getMessage() + ")");
                }
            }
        }
        if (infoClass == null) {
            throw new IllegalArgumentException("Illegal type found in info map (could not load class for specified type)");
        }
        return ObjectType.instanceOf(obj, infoClass);
    }

    public static boolean instanceOf(Object obj, Class<?> typeClass) {
        if (obj == null) {
            return true;
        }
        Class<?> objectClass = obj.getClass();
        if (typeClass.isInterface()) {
            return ObjectType.interfaceOf(obj, typeClass);
        }
        return ObjectType.isOrSubOf(obj, typeClass);
    }

    public static Object simpleTypeConvert(Object obj, String type, String format, Locale locale) throws GeneralException {
        if (obj == null) {
            return null;
        }
        if ("PlainString".equals(type)) {
            return obj.toString();
        }
        if ("Object".equals(type)) {
            return obj;
        }
        String fromType = null;
        if (obj instanceof String) {
            fromType = "String";
            String str = (String)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return obj;
            }
            if (str.length() == 0) {
                return null;
            }
            if ("Boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                return str.equalsIgnoreCase("TRUE");
            }
            if ("Locale".equals(type) || "java.util.Locale".equals(type)) {
                Locale loc = UtilMisc.parseLocale(str);
                if (loc != null) {
                    return loc;
                }
                throw new GeneralException("Could not convert " + str + " to " + type + ": ");
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                try {
                    NumberFormat nf = null;
                    nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
                    Number tempNum = nf.parse(str);
                    return tempNum.doubleValue();
                }
                catch (ParseException e) {
                    throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                try {
                    NumberFormat nf = null;
                    nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
                    Number tempNum = nf.parse(str);
                    return Float.valueOf(tempNum.floatValue());
                }
                catch (ParseException e) {
                    throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                try {
                    NumberFormat nf = null;
                    nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
                    nf.setMaximumFractionDigits(0);
                    Number tempNum = nf.parse(str);
                    return tempNum.longValue();
                }
                catch (ParseException e) {
                    throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                try {
                    NumberFormat nf = null;
                    nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
                    nf.setMaximumFractionDigits(0);
                    Number tempNum = nf.parse(str);
                    return tempNum.intValue();
                }
                catch (ParseException e) {
                    throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                if (format == null || format.length() == 0) {
                    try {
                        return Date.valueOf(str);
                    }
                    catch (Exception e) {
                        try {
                            DateFormat df = null;
                            df = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3);
                            java.util.Date fieldDate = df.parse(str);
                            return new Date(fieldDate.getTime());
                        }
                        catch (ParseException e1) {
                            throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                        }
                    }
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    java.util.Date fieldDate = sdf.parse(str);
                    return new Date(fieldDate.getTime());
                }
                catch (ParseException e) {
                    throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Time".equals(type) || "java.sql.Time".equals(type)) {
                if (format == null || format.length() == 0) {
                    try {
                        return Time.valueOf(str);
                    }
                    catch (Exception e) {
                        try {
                            DateFormat df = null;
                            df = locale != null ? DateFormat.getTimeInstance(3, locale) : DateFormat.getTimeInstance(3);
                            java.util.Date fieldDate = df.parse(str);
                            return new Time(fieldDate.getTime());
                        }
                        catch (ParseException e1) {
                            throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                        }
                    }
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    java.util.Date fieldDate = sdf.parse(str);
                    return new Time(fieldDate.getTime());
                }
                catch (ParseException e) {
                    throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                if (format == null || format.length() == 0) {
                    try {
                        return Timestamp.valueOf(str);
                    }
                    catch (Exception e) {
                        try {
                            DateFormat df = null;
                            df = locale != null ? DateFormat.getDateTimeInstance(3, 3, locale) : DateFormat.getDateTimeInstance(3, 3);
                            java.util.Date fieldDate = df.parse(str);
                            return new Timestamp(fieldDate.getTime());
                        }
                        catch (ParseException e1) {
                            throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                        }
                    }
                }
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    java.util.Date fieldDate = sdf.parse(str);
                    return new Timestamp(fieldDate.getTime());
                }
                catch (ParseException e) {
                    throw new GeneralException("Could not convert " + str + " to " + type + ": ", e);
                }
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Double) {
            fromType = "Double";
            Double dbl = (Double)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                NumberFormat nf = null;
                nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
                return nf.format(dbl);
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return obj;
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                return Float.valueOf(dbl.floatValue());
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return Math.round(dbl);
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return (int)Math.round(dbl);
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Float) {
            fromType = "Float";
            Float flt = (Float)obj;
            if ("String".equals(type)) {
                NumberFormat nf = null;
                nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
                return nf.format(flt.doubleValue());
            }
            if ("Double".equals(type)) {
                return flt.doubleValue();
            }
            if ("Float".equals(type)) {
                return obj;
            }
            if ("Long".equals(type)) {
                return Math.round(flt.doubleValue());
            }
            if ("Integer".equals(type)) {
                return (int)Math.round(flt.doubleValue());
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Long) {
            fromType = "Long";
            Long lng = (Long)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                NumberFormat nf = null;
                nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
                return nf.format(lng);
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return lng.doubleValue();
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                return Float.valueOf(lng.floatValue());
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return obj;
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return lng.intValue();
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Integer) {
            fromType = "Integer";
            Integer intgr = (Integer)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                NumberFormat nf = null;
                nf = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
                return nf.format(intgr.longValue());
            }
            if ("Double".equals(type) || "java.lang.Double".equals(type)) {
                return intgr.doubleValue();
            }
            if ("Float".equals(type) || "java.lang.Float".equals(type)) {
                return Float.valueOf(intgr.floatValue());
            }
            if ("Long".equals(type) || "java.lang.Long".equals(type)) {
                return intgr.longValue();
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                return obj;
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Date) {
            fromType = "Date";
            Date dte = (Date)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                if (format == null || format.length() == 0) {
                    return dte.toString();
                }
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return sdf.format(new java.util.Date(dte.getTime()));
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                return obj;
            }
            if ("Time".equals(type) || "java.sql.Time".equals(type)) {
                throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                return new Timestamp(dte.getTime());
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Time) {
            fromType = "Time";
            Time tme = (Time)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                if (format == null || format.length() == 0) {
                    return tme.toString();
                }
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return sdf.format(new java.util.Date(tme.getTime()));
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
            }
            if ("Time".equals(type) || "java.sql.Time".equals(type)) {
                return obj;
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                return new Timestamp(tme.getTime());
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Timestamp) {
            fromType = "Timestamp";
            Timestamp tme = (Timestamp)obj;
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                if (format == null || format.length() == 0) {
                    return tme.toString();
                }
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                return sdf.format(new java.util.Date(tme.getTime()));
            }
            if ("Date".equals(type) || "java.sql.Date".equals(type)) {
                return new Date(tme.getTime());
            }
            if ("Time".equals(type) || "java.sql.Time".equals(type)) {
                return new Time(tme.getTime());
            }
            if ("Timestamp".equals(type) || "java.sql.Timestamp".equals(type)) {
                return obj;
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Boolean) {
            fromType = "Boolean";
            Boolean bol = (Boolean)obj;
            if ("Boolean".equals(type) || "java.lang.Boolean".equals(type)) {
                return bol;
            }
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return bol.toString();
            }
            if ("Integer".equals(type) || "java.lang.Integer".equals(type)) {
                if (bol.booleanValue()) {
                    return 1;
                }
                return 0;
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        if (obj instanceof Locale) {
            fromType = "Locale";
            Locale loc = (Locale)obj;
            if ("Locale".equals(type) || "java.util.Locale".equals(type)) {
                return loc;
            }
            if ("String".equals(type) || "java.lang.String".equals(type)) {
                return loc.toString();
            }
            throw new GeneralException("Conversion from " + fromType + " to " + type + " not currently supported");
        }
        throw new GeneralException("Conversion from " + obj.getClass().getName() + " to " + type + " not currently supported");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean doRealCompare(Object value1, Object value2, String operator, String type, String format, List<String> messages, Locale locale, ClassLoader loader) {
        String str2;
        String str1;
        boolean verboseOn = Debug.verboseOn();
        if (verboseOn) {
            Debug.logVerbose("Comparing value1: \"" + value1 + "\" " + operator + " value2:\"" + value2 + "\"");
        }
        int result = 0;
        Object convertedValue1 = null;
        try {
            convertedValue1 = ObjectType.simpleTypeConvert(value1, type, format, locale);
        }
        catch (GeneralException e) {
            messages.add("Could not convert value1 for comparison: " + e.getMessage());
            return null;
        }
        Object convertedValue2 = null;
        if (value2 != null) {
            try {
                convertedValue2 = ObjectType.simpleTypeConvert(value2, type, format, locale);
            }
            catch (GeneralException e) {
                messages.add("Could not convert value2 for comparison: " + e.getMessage());
                return null;
            }
        }
        if (convertedValue1 == null && !"is-not-empty".equals(operator) && !"is-empty".equals(operator)) {
            if (verboseOn) {
                Debug.logVerbose("Value1 was null, cannot complete comparison");
            }
            return null;
        }
        if (convertedValue2 == null && !"is-not-empty".equals(operator) && !"is-empty".equals(operator)) {
            if (verboseOn) {
                Debug.logVerbose("Value2 was null, cannot complete comparison");
            }
            return null;
        }
        if ("contains".equals(operator)) {
            if (!"String".equals(type) && !"PlainString".equals(type)) {
                messages.add("Error in XML file: cannot do a contains compare with a non-String type");
                return null;
            }
            str1 = (String)convertedValue1;
            str2 = (String)convertedValue2;
            if (!str1.contains(str2)) {
                return Boolean.FALSE;
            }
        }
        if ("is-empty".equals(operator)) {
            if (value1 == null) {
                return Boolean.TRUE;
            }
            if (value1 instanceof String && ((String)value1).length() == 0) {
                return Boolean.TRUE;
            }
            if (value1 instanceof List && ((List)value1).size() == 0) {
                return Boolean.TRUE;
            }
            if (value1 instanceof Map && ((Map)value1).size() == 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if ("is-not-empty".equals(operator)) {
            if (value1 == null) {
                return Boolean.FALSE;
            }
            if (value1 instanceof String && ((String)value1).length() == 0) {
                return Boolean.FALSE;
            }
            if (value1 instanceof List && ((List)value1).size() == 0) {
                return Boolean.FALSE;
            }
            if (value1 instanceof Map && ((Map)value1).size() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ("String".equals(type) || "PlainString".equals(type)) {
            str1 = (String)convertedValue1;
            str2 = (String)convertedValue2;
            if (str1.length() == 0 || str2.length() == 0) {
                return null;
            }
            result = str1.compareTo(str2);
        } else if ("Double".equals(type) || "Float".equals(type) || "Long".equals(type) || "Integer".equals(type)) {
            double value2Double;
            Number tempNum = (Number)convertedValue1;
            double value1Double = tempNum.doubleValue();
            result = value1Double < (value2Double = (tempNum = (Number)convertedValue2).doubleValue()) ? -1 : (value1Double > value2Double ? 1 : 0);
        } else if ("Date".equals(type)) {
            Date value1Date = (Date)convertedValue1;
            Date value2Date = (Date)convertedValue2;
            result = value1Date.compareTo(value2Date);
        } else if ("Time".equals(type)) {
            Time value1Time = (Time)convertedValue1;
            Time value2Time = (Time)convertedValue2;
            result = value1Time.compareTo(value2Time);
        } else if ("Timestamp".equals(type)) {
            Timestamp value1Timestamp = (Timestamp)convertedValue1;
            Timestamp value2Timestamp = (Timestamp)convertedValue2;
            result = value1Timestamp.compareTo(value2Timestamp);
        } else if ("Boolean".equals(type)) {
            Boolean value1Boolean = (Boolean)convertedValue1;
            Boolean value2Boolean = (Boolean)convertedValue2;
            if ("equals".equals(operator)) {
                result = value1Boolean.booleanValue() && value2Boolean.booleanValue() || !value1Boolean.booleanValue() && !value2Boolean.booleanValue() ? 0 : 1;
            } else {
                if (!"not-equals".equals(operator)) {
                    messages.add("Can only compare Booleans using the operators 'equals' or 'not-equals'");
                    return null;
                }
                result = !value1Boolean.booleanValue() && value2Boolean.booleanValue() || value1Boolean.booleanValue() && !value2Boolean.booleanValue() ? 0 : 1;
            }
        } else {
            if (!"Object".equals(type)) {
                messages.add("Type \"" + type + "\" specified for compare not supported.");
                return null;
            }
            result = convertedValue1.equals(convertedValue2) ? 0 : 1;
        }
        if (verboseOn) {
            Debug.logVerbose("Got Compare result: " + result + ", operator: " + operator);
        }
        if ("less".equals(operator)) {
            if (result >= 0) {
                return Boolean.FALSE;
            }
        } else if ("greater".equals(operator)) {
            if (result <= 0) {
                return Boolean.FALSE;
            }
        } else if ("less-equals".equals(operator)) {
            if (result > 0) {
                return Boolean.FALSE;
            }
        } else if ("greater-equals".equals(operator)) {
            if (result < 0) {
                return Boolean.FALSE;
            }
        } else if ("equals".equals(operator)) {
            if (result != 0) {
                return Boolean.FALSE;
            }
        } else {
            if (!"not-equals".equals(operator)) {
                messages.add("Specified compare operator \"" + operator + "\" not known.");
                return null;
            }
            if (result == 0) {
                return Boolean.FALSE;
            }
        }
        if (verboseOn) {
            Debug.logVerbose("Returning true");
        }
        return Boolean.TRUE;
    }
}

