package com.atlassian.oauth2.scopes.api;

import java.util.Set;

/**
 * A product-agnostic service for obtaining {@link Scope} objects by name.
 */
public interface ScopeResolver {

    /**
     * Will try to get the scope from the name.
     * @param scopeName the scope name to match
     * @return The scope that matches the scopeName
     * @throws InvalidScopeException if fails to find the scope
     * @see #getAvailableScopes() for a list of available scopes and their names
     */
    Scope getScope(String scopeName) throws InvalidScopeException;

    /**
     * Will check if the tokenScope has permission against the configScope
     * If the tokenScope is higher than the configScope then this will return false
     * @param tokenScope the scope to check
     * @param configScope the scope to check against
     * @return true if tokenScope is within configScope, false otherwise
     */
    boolean hasScopePermission(Scope tokenScope, Scope configScope);

    /**
     * Gets the set of scopes for this product
     * @return the set of scopes for this product
     */
    Set<Scope> getAvailableScopes();
}
