package com.atlassian.oauth2.scopes.api;

import com.google.common.collect.ImmutableList;

import java.util.List;
import java.util.Objects;

public class ScopeDescription {

    private final List<String> descriptions;

    public ScopeDescription(final List<String> descriptions) {
        this.descriptions = descriptions;
    }

    public ScopeDescription(final String descriptions) {
        this.descriptions = ImmutableList.of(descriptions);
    }

    public List<String> getDescriptions() {
        return descriptions;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final ScopeDescription that = (ScopeDescription) o;
        return descriptions.equals(that.descriptions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(descriptions);
    }
}
