package com.atlassian.oauth2.scopes.api;

import com.google.common.base.Preconditions;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;

public class CompositeScope implements Scope {

    private final Set<Scope> scopes;

    public CompositeScope(@Nonnull final Set<Scope> scopes) {
        Preconditions.checkArgument(!scopes.isEmpty(), "Composite scopes cannot be empty");
        this.scopes = scopes;
    }

    @Override
    @Nonnull
    public String getName() {
        return scopes.stream()
                .sorted(Comparator.comparing(Scope::getName))
                .map(Scope::getName)
                .collect(Collectors.joining(" "));
    }

    @Override
    @Nonnull
    public Set<Scope> getScopeAndInheritedScopes() {
        return scopes.stream()
                .map(Scope::getScopeAndInheritedScopes)
                .flatMap(Collection::stream)
                .collect(Collectors.toSet());
    }

    @Override
    public String toString() {
        return getName();
    }
}
