package com.atlassian.oauth2.provider.api.token.refresh.dao;

import com.atlassian.oauth2.provider.api.token.refresh.RefreshToken;
import com.atlassian.oauth2.scopes.api.Scope;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NonNull;
import lombok.ToString;

@ToString
@EqualsAndHashCode
@Getter
@Builder(toBuilder = true)
@AllArgsConstructor
public class RefreshTokenEntity implements RefreshToken {

    @NonNull
    private final String id;

    @NonNull
    private final String accessTokenId;

    @NonNull
    private final String clientId;

    @NonNull
    private final String userKey;

    @NonNull
    private final Scope scope;

    @NonNull
    private final String authorizationCode;

    @NonNull
    private final Long authorizationDate;

    @NonNull
    private final Long createdAt;

    private final Integer refreshCount;
}
