package com.atlassian.oauth2.provider.api.token.refresh.dao;

import com.atlassian.oauth2.provider.api.token.refresh.RefreshToken;

import javax.annotation.Nonnull;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public interface RefreshTokenDao {

    @Nonnull
    RefreshToken create(RefreshToken refreshTokenEntity);

    @Nonnull
    Optional<RefreshToken> findByTokenId(String refreshTokenId);

    @Nonnull
    List<RefreshToken> findByClientId(String clientId);

    @Nonnull
    List<RefreshToken> findByUserKey(String userKey);

    @Nonnull
    List<RefreshToken> findByAuthorizationCode(String authorizationCode);

    @Nonnull
    Optional<RefreshToken> removeByRefreshTokenId(String refreshTokenId);

    Optional<RefreshToken> removeByAccessTokenId(String accessTokenId);

    @Nonnull
    List<RefreshToken> removeByClientId(String clientId);

    List<RefreshToken> removeAllByAuthorizationCode(String authorizationCode);

    void removeExpiredTokensAfter(Duration expiration);
}
