package com.atlassian.oauth2.provider.api.token.refresh;

import com.atlassian.oauth2.scopes.api.Scope;

import javax.annotation.Nonnull;

public interface RefreshToken {

    @Nonnull
    String getId();

    @Nonnull
    String getAccessTokenId();

    @Nonnull
    String getClientId();

    @Nonnull
    String getUserKey();

    @Nonnull
    Scope getScope();

    @Nonnull
    String getAuthorizationCode();

    @Nonnull
    Long getAuthorizationDate();

    @Nonnull
    Long getCreatedAt();

    Integer getRefreshCount();
}
