package com.atlassian.oauth2.provider.api.token;

import com.atlassian.oauth2.scopes.api.Scope;

public class AuthenticationResult {
    private final Scope scope;
    private final String clientId;
    private final boolean authenticated;

    public static AuthenticationResult authenticated(final Scope scope,
                                                     final String clientId) {
        return new AuthenticationResult(scope, clientId, true);
    }

    public static AuthenticationResult notAuthenticated() {
        return new AuthenticationResult(null, null,false);
    }

    private AuthenticationResult(final Scope scope,
                                 final String clientId,
                                 final boolean authenticated) {
        this.scope = scope;
        this.clientId = clientId;
        this.authenticated = authenticated;
    }

    public Scope getScope() {
        return scope;
    }

    public String getClientId() {
        return clientId;
    }

    public boolean isAuthenticated() {
        return authenticated;
    }
}
