package com.atlassian.oauth2.provider.api.settings;

public interface ProviderSettingsDao {

    /**
     * Create and Save JWT secret to plugin settings, if one does not already exist.
     */
    void saveJwtSecret();

    /**
     * Generate and save JWT secret to plugin settings.
     */
    void resetJwtSecret();

    /**
     * Get the JWT Secret from plugin settings
     *
     * @return JWT Secret
     */
    String getJwtSecret();
}
