package com.atlassian.oauth2.provider.api.pkce;

import javax.annotation.Nonnull;

/**
 * Methods used by the PKCE implementation
 * https://datatracker.ietf.org/doc/html/rfc7636
 */
public interface PkceService {

    /**
     * Checks if the given string is a valid PKCE code challenge or PKCE code verifier.
     * This method SHOULD NOT be used on authorization codes.
     *
     * Input must have at least 43 characters.
     * Input must not have more than 128 characters.
     * Input must only contain characters from "a-z"/"A-Z"/"0-9"/"-"/"."/"_"/"~".
     *
     * @param input the string to check.
     * @return true if valid.
     */
    boolean isValidCode(@Nonnull String input);

    /**
     * Checks if the expected code challenge is produced by applying the
     * given code challenge method to the given code verifier.
     *
     * @param expectedCodeChallenge the expected code challenge from applying the transformation
     * @param codeChallengeMethod the transformation to apply to the code verifier
     * @param codeVerifier the code verifier
     * @return true if the expected code challenge was produced
     */
    boolean isExpectedCodeChallengeGenerated(@Nonnull String expectedCodeChallenge,
                                             @Nonnull CodeChallengeMethod codeChallengeMethod,
                                             @Nonnull String codeVerifier);
}
