package com.atlassian.oauth2.provider.api.event.client;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.oauth2.provider.api.client.Client;

@EventName("plugins.oauth2.provider.client.updated")
public class ClientConfigurationUpdatedEvent extends ClientConfigurationEvent {

    public ClientConfigurationUpdatedEvent(final Client oldClient, final Client newClient) {
        super(oldClient, newClient);
    }

    public String getScope() {
        return newClient.getScope().getName();
    }
}

