package com.atlassian.oauth2.provider.api.authorization;

/**
 * Lower level errors
 */
public enum TokenResponseErrorDescription {
    INVALID_CLIENT_ID(TokenResponseError.INVALID_CLIENT, "invalid_client_id"),
    INVALID_REDIRECT_URI(TokenResponseError.INVALID_GRANT, "invalid_redirect_uri"),
    INVALID_CODE(TokenResponseError.INVALID_REQUEST, "invalid_code");

    public final TokenResponseError error;
    public final String name;

    TokenResponseErrorDescription(final TokenResponseError error,
                                  final String name) {
        this.error = error;
        this.name = name;
    }
}
