/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.util;

import com.google.common.base.Preconditions;
import javax.servlet.http.HttpServletRequest;

public class RequestAnnotations {
    private static final String OAUTH_REQUEST_FLAG = "com.atlassian.oath.request-flag";
    private static final String OAUTH_CONSUMER_KEY = "com.atlassian.oath.consumer-key";

    public static boolean isOAuthRequest(HttpServletRequest req) throws NullPointerException {
        Preconditions.checkNotNull((Object)req);
        return req.getAttribute(OAUTH_REQUEST_FLAG) != null;
    }

    public static void markAsOAuthRequest(HttpServletRequest req) throws NullPointerException {
        Preconditions.checkNotNull((Object)req);
        req.setAttribute(OAUTH_REQUEST_FLAG, (Object)"true");
    }

    public static String getOAuthConsumerKey(HttpServletRequest req) {
        Preconditions.checkNotNull((Object)req);
        Preconditions.checkState((boolean)RequestAnnotations.isOAuthRequest(req), (Object)"cannot get OAuth consumer key out of non-OAuth request!");
        return (String)req.getAttribute(OAUTH_CONSUMER_KEY);
    }

    public static void setOAuthConsumerKey(HttpServletRequest req, String consumerKey) {
        Preconditions.checkNotNull((Object)req);
        Preconditions.checkNotNull((Object)consumerKey);
        req.setAttribute(OAUTH_CONSUMER_KEY, (Object)consumerKey);
    }
}

