package com.atlassian.messagequeue;

import com.atlassian.annotations.PublicApi;

/**
 * Interface for running messages.
 * @since 1.0
 */
@PublicApi
public interface MessageRunnerService {

    /**
     * Adds a message that will be executed at some future point. Messages may not be executed in the order in which they
     * are added.
     * @param message message specification
     * @throws MessageRunnerNotRegisteredException if no runner is registered for the given message's runner key
     * @throws MessagePayloadSizeExceededException when a payload that is too large is passed
     */
    void addMessage(Message message);
}
