/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.api.entity;

import com.atlassian.fugue.Option;
import com.atlassian.media.client.api.entity.Artifact;
import com.atlassian.media.client.api.entity.ArtifactType;
import com.atlassian.media.client.api.entity.ProcessingStatus;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Entity {
    private final String id;
    private final String mimeType;
    private final String mediaType;
    private final String name;
    private final ProcessingStatus processingStatus;
    private final long size;
    private final Map<ArtifactType, Artifact> artifacts;

    public Entity(String id, @Nullable String mimeType, @Nullable String type, @Nullable String name, String processingStatus, long size, Map<ArtifactType, Artifact> artifacts) {
        this.id = Objects.requireNonNull(id);
        this.mimeType = mimeType;
        this.mediaType = type;
        this.name = name;
        this.processingStatus = ProcessingStatus.fromStatusName(Objects.requireNonNull(processingStatus));
        this.size = Objects.requireNonNull(size);
        this.artifacts = Collections.unmodifiableMap(Objects.requireNonNull(artifacts));
    }

    public String getId() {
        return this.id;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getName() {
        return this.name;
    }

    public ProcessingStatus getProcessingStatus() {
        return this.processingStatus;
    }

    public long getSize() {
        return this.size;
    }

    public Map<ArtifactType, Artifact> getArtifacts() {
        return this.artifacts;
    }

    public Option<Artifact> getArtifact(@Nonnull ArtifactType type) {
        return Option.option((Object)this.artifacts.get((Object)Objects.requireNonNull(type)));
    }

    public String toString() {
        return "Entity{artifacts=" + this.artifacts + ", id='" + this.id + '\'' + ", mimeType='" + this.mimeType + '\'' + ", mediaType='" + this.mediaType + '\'' + ", name='" + this.name + '\'' + ", processingStatus=" + (Object)((Object)this.processingStatus) + ", size=" + this.size + '}';
    }
}

