/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.media.client.api.entity;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class ChunkETag {
    private static final String DELIM = "-";
    private static final Pattern sha1Pattern = Pattern.compile("^[0-9a-fA-F]{40}$");
    private final String sha1;
    private final int length;

    public ChunkETag(String sha1, int length) {
        this.sha1 = ChunkETag.validSha1(sha1);
        this.length = ChunkETag.notNegative(length);
    }

    private static int notNegative(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative:" + length);
        }
        return length;
    }

    private static String validSha1(String sha1) {
        if (!sha1Pattern.matcher(Objects.requireNonNull(sha1)).matches()) {
            throw new IllegalArgumentException("Malformed SHA1:" + sha1);
        }
        return sha1;
    }

    @Nonnull
    public String getSha1() {
        return this.sha1;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return this.sha1 + DELIM + this.length;
    }
}

