/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins;

import com.atlassian.maven.plugins.InvalidResourceException;
import com.atlassian.maven.plugins.PathParserUtil;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;

public class UploadMojo
extends AbstractMojo {
    private String resourceSrc;
    private String resourceDest;
    private String url;
    private String serverId;
    private boolean ignoreInvalidResource;
    private WagonManager wagonManager;
    private Settings settings;

    public void execute() throws MojoExecutionException {
        Set uploadResources = PathParserUtil.toFiles(this.resourceSrc);
        if (uploadResources.isEmpty()) {
            String message = "Resource " + this.resourceSrc + " does not match an existing file or directory.";
            if (this.ignoreInvalidResource) {
                this.getLog().info((CharSequence)message);
                return;
            }
            throw new InvalidResourceException(message);
        }
        if (uploadResources == null || uploadResources.isEmpty()) {
            throw new MojoExecutionException("The resources to upload are not specified.");
        }
        if (this.url == null) {
            throw new MojoExecutionException("The URL to upload to is missing.");
        }
        this.upload(uploadResources);
    }

    /*
     * Loose catch block
     */
    private void upload(Set uploadResources) throws MojoExecutionException {
        block15: {
            Repository repository = new Repository(this.serverId, this.url);
            Debug debug = new Debug();
            this.getLog().debug((CharSequence)("Upload URL: " + this.url));
            this.getLog().debug((CharSequence)("Upload Server ID: " + this.serverId));
            try {
                Wagon wagon = this.wagonManager.getWagon(repository);
                Iterator iterator = uploadResources.iterator();
                while (iterator.hasNext()) {
                    File resource = (File)iterator.next();
                    if (!resource.isDirectory() || wagon.supportsDirectoryCopy()) continue;
                    throw new MojoExecutionException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying. " + resource + " will fail to upload.");
                }
                wagon.addSessionListener((SessionListener)debug);
                wagon.addTransferListener((TransferListener)debug);
                ProxyInfo proxyInfo = UploadMojo.getProxyInfo(this.settings);
                if (proxyInfo != null) {
                    wagon.connect(repository, this.wagonManager.getAuthenticationInfo(repository.getId()), proxyInfo);
                } else {
                    wagon.connect(repository, this.wagonManager.getAuthenticationInfo(repository.getId()));
                }
                Iterator iterator2 = uploadResources.iterator();
                while (iterator2.hasNext()) {
                    File resource = (File)iterator2.next();
                    if (resource.isDirectory()) {
                        wagon.putDirectory(resource, this.resourceDest + '/' + resource.getName());
                        continue;
                    }
                    wagon.put(resource, this.resourceDest + '/' + resource.getName());
                }
                Object var9_11 = null;
                try {
                    wagon.disconnect();
                }
                catch (ConnectionException e) {
                    this.getLog().debug((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
                }
                break block15;
                {
                    catch (WagonException e) {
                        throw new MojoExecutionException("Error uploading resource", (Exception)((Object)e));
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    try {
                        wagon.disconnect();
                    }
                    catch (ConnectionException e) {
                        this.getLog().debug((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
                    }
                    throw throwable;
                }
            }
            catch (UnsupportedProtocolException e) {
                throw new MojoExecutionException("Unsupported protocol: '" + repository.getProtocol() + "'", (Exception)((Object)e));
            }
            catch (WagonConfigurationException e) {
                throw new MojoExecutionException("Unable to configure Wagon: '" + repository.getProtocol() + "'", (Exception)((Object)e));
            }
        }
    }

    private static ProxyInfo getProxyInfo(Settings settings) {
        ProxyInfo proxyInfo = null;
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy settingsProxy = settings.getActiveProxy();
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(settingsProxy.getHost());
            proxyInfo.setType(settingsProxy.getProtocol());
            proxyInfo.setPort(settingsProxy.getPort());
            proxyInfo.setNonProxyHosts(settingsProxy.getNonProxyHosts());
            proxyInfo.setUserName(settingsProxy.getUsername());
            proxyInfo.setPassword(settingsProxy.getPassword());
        }
        return proxyInfo;
    }
}

