/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.distribution.scriptwriter;

import com.atlassian.distribution.scriptwriter.AbstractScriptWriter;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class PosixScriptWriter
extends AbstractScriptWriter {
    public PosixScriptWriter(File directory, String filename, boolean withTests) {
        super(directory, filename, withTests);
        this.newLine = "\n";
        this.extraCli = " \"$@\"";
        this.preliminaryLines.add("#! /bin/sh");
        this.preliminaryLines.add("cd \"`dirname \"$0\"`\"");
    }

    @Override
    public void addSettingsLine(String settingsFilename) {
        this.preliminaryLines.add("SETTINGSFILE=\"" + settingsFilename + "\"");
        this.addToMavenCommands("-s $SETTINGSFILE");
    }

    @Override
    public void addLocalRepoLine(String localRepoFilename) {
        this.preliminaryLines.add("LOCALREPO=\"" + localRepoFilename + "\"");
        this.addToMavenCommands("-Dmaven.repo.local=\"`pwd`/$LOCALREPO\"");
    }

    @Override
    public void addCurrentDirToPath() {
        this.preliminaryLines.add("export PATH=.:$PATH");
    }

    @Override
    public void useErrorMode() {
        this.preliminaryLines.add("set -e");
    }

    @Override
    public void addOtherPreliminaryLine(String line) {
        this.preliminaryLines.add(line);
    }

    @Override
    public void addCommand(String command, boolean isMaven, boolean takesExtraCli) {
        this.addCommand(command, "", isMaven, takesExtraCli);
    }

    @Override
    public void addCommand(String command, String arguments, boolean isMaven, boolean takesExtraCli) {
        String cmd = command;
        if (!StringUtils.isBlank((String)arguments)) {
            cmd = cmd + " " + arguments;
        }
        if (isMaven) {
            cmd = cmd + this.appendToMavenCommands;
        }
        if (takesExtraCli) {
            cmd = cmd + this.extraCli;
        }
        this.commands.add(cmd);
    }
}

