/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.distribution.scriptwriter;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractScriptWriter {
    protected String filename;
    protected File directory;
    protected FileWriter fileWriter;
    protected List<String> preliminaryLines = new ArrayList<String>();
    protected List<String> commands = new ArrayList<String>();
    protected String betweenEachCommand = "";
    protected String newLine = "";
    protected String appendToMavenCommands = "";
    protected String extraCli = "";

    public AbstractScriptWriter(File directory, String filename, boolean withTests) {
        this.filename = filename;
        this.directory = directory;
        if (!withTests) {
            this.appendToMavenCommands = " -Dmaven.test.skip";
        }
    }

    public void writeScript() throws IOException {
        this.useErrorMode();
        this.addCurrentDirToPath();
        File scriptFile = new File(this.directory, this.filename);
        this.fileWriter = new FileWriter(scriptFile);
        for (String preliminary : this.preliminaryLines) {
            this.fileWriter.write(preliminary + this.newLine);
        }
        for (String command : this.commands) {
            this.fileWriter.write(command + this.newLine);
            if (StringUtils.isBlank((String)this.betweenEachCommand)) continue;
            this.fileWriter.write(this.betweenEachCommand + this.newLine);
        }
        scriptFile.setExecutable(true, false);
        this.fileWriter.flush();
        this.fileWriter.close();
    }

    protected void addToMavenCommands(String extraArgs) {
        this.appendToMavenCommands = this.appendToMavenCommands + " " + extraArgs;
    }

    public void includeSettingsFile(String sourceFilename, String destFilename) throws IOException {
        FileUtils.copyFile((File)new File(sourceFilename), (File)new File(this.directory, destFilename));
    }

    public abstract void addSettingsLine(String var1);

    public abstract void addLocalRepoLine(String var1);

    public abstract void addCurrentDirToPath();

    public abstract void useErrorMode();

    public abstract void addOtherPreliminaryLine(String var1);

    public abstract void addCommand(String var1, boolean var2, boolean var3);

    public abstract void addCommand(String var1, String var2, boolean var3, boolean var4);
}

