/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.markup.renderer.util;

import com.google.common.base.Function;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    public static final Function<MatchResult, String[]> MATCH_RESULT_TO_ARRAY = new Function<MatchResult, String[]>(){

        public String[] apply(MatchResult matcher) {
            String[] groups = new String[matcher.groupCount()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = matcher.group(i + 1);
            }
            return groups;
        }
    };

    public static CharSequence replaceAll(Pattern pattern, CharSequence input, Function<MatchResult, String> replacer) {
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        boolean matched = false;
        while (matcher.find()) {
            matched = true;
            matcher.appendReplacement(sb, Matcher.quoteReplacement((String)replacer.apply((Object)matcher)));
        }
        if (!matched) {
            return input;
        }
        matcher.appendTail(sb);
        return sb;
    }
}

