/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.markup.renderer.impl;

import com.atlassian.markup.renderer.MarkupRenderer;
import com.atlassian.markup.renderer.MarkupRendererComponentModuleDescriptor;
import com.atlassian.markup.renderer.RenderContext;
import com.atlassian.markup.renderer.RenderTransform;
import com.atlassian.markup.renderer.impl.TokenReplacer;
import com.atlassian.markup.renderer.impl.TransformUtils;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharSequenceReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkupRendererImpl
implements MarkupRenderer {
    private static final Logger log = LoggerFactory.getLogger(MarkupRendererImpl.class);
    private final PluginAccessor pluginAccessor;
    private final Function<? super CharSequence, ? extends CharSequence> transform;

    public MarkupRendererImpl(PluginAccessor pluginAccessor, Function<? super CharSequence, ? extends CharSequence> transform) {
        this.pluginAccessor = pluginAccessor;
        this.transform = transform;
    }

    @Override
    public Reader render(Reader content, RenderContext context) throws IOException {
        TokenReplacer tokenReplacer = this.renderReplace(content, context);
        CharSequence markup = (CharSequence)this.transform.apply((Object)tokenReplacer.getIntermediate());
        return new CharSequenceReader(tokenReplacer.resolve(markup));
    }

    private TokenReplacer renderReplace(Reader content, RenderContext context) throws IOException {
        List handlers = this.pluginAccessor.getEnabledModuleDescriptorsByClass(MarkupRendererComponentModuleDescriptor.class);
        String input = IOUtils.toString((Reader)content);
        if (!handlers.isEmpty()) {
            return MarkupRendererImpl.transform(input, context, handlers);
        }
        return new TokenReplacer(input, (Function<CharSequence, CharSequence>)Functions.identity());
    }

    protected static TokenReplacer transform(final CharSequence input, final RenderContext context, Iterable<MarkupRendererComponentModuleDescriptor> modules) {
        return TransformUtils.tokenReplace(input, Iterables.transform(modules, (Function)new Function<MarkupRendererComponentModuleDescriptor, RenderTransform>(){

            public RenderTransform apply(MarkupRendererComponentModuleDescriptor descriptor) {
                try {
                    return descriptor.getModule().process(input, context);
                }
                catch (Exception e) {
                    log.warn("{} failed to transform markup due to an unexpected exception. Skipping transformation.", (Object)descriptor.getCompleteKey(), (Object)e);
                    return RenderTransform.builder().build();
                }
            }
        }));
    }
}

