;function quickReloadBatchModeSwitcherInit ($, AJS) {
    // From underscore 1.8.3
    // Returns a function, that, when invoked, will only be triggered at most once
    // during a given window of time. Normally, the throttled function will run
    // as much as it can, without ever going more than once per `wait` duration;
    // but if you'd like to disable the execution on the leading edge, pass
    // `{leading: false}`. To disable execution on the trailing edge, ditto.
    var throttle = function(func, wait, options) {
        var context, args, result;
        var timeout = null;
        var previous = 0;
        if (!options) options = {};
        var later = function() {
            previous = options.leading === false ? 0 : Date.now();
            timeout = null;
            result = func.apply(context, args);
            if (!timeout) context = args = null;
        };
        return function() {
            var now = Date.now();
            if (!previous && options.leading === false) previous = now;
            var remaining = wait - (now - previous);
            context = this;
            args = arguments;
            if (remaining <= 0 || remaining > wait) {
                if (timeout) {
                    clearTimeout(timeout);
                    timeout = null;
                }
                previous = now;
                result = func.apply(context, args);
                if (!timeout) context = args = null;
            } else if (!timeout && options.trailing !== false) {
                timeout = setTimeout(later, remaining);
            }
            return result;
        };
    };

    var searchForContextPath = function() {
        if($.isFunction(AJS.contextPath)) {
            return AJS.contextPath();
        } else if (AJS.Meta && $.isFunction(AJS.Meta.get)) {
            try {
                return AJS.Meta.get("context-path");
            } catch(ignored) {}
        }

        return null;
    };

    var getCurrentBatchModeStateUrl = function(contextPath) {
        return contextPath + "/rest/qr/batching";
    };

    var getUpdateBatchModeUrl = function(contextPath, enableBatching) {
        return contextPath + "/rest/qr/batching/setState?enabled=" + !!enableBatching;
    };

    var tryGrabAuiFlag = function() {
        try {
            if($.isFunction(require)) {
                return require("aui/flag");
            }
        } catch(notFoundException) {}

        return null;
    };

    var getToastSuccessTitle = function(newBatchedModeState) {
        if(!!newBatchedModeState) {
            return "Fast mode";
        } else {
            return "Dev mode";
        }
    };

    var getToastSuccessMessageHtml = function(newBatchedModeState) {
        if(!!newBatchedModeState) {
            return "Web resource batching enabled. Dev mode disabled.";
        } else {
            return "Web resource batching disabled.";
        }
    };

    var toastSuccess = function(title, messageHtml) {
        toastMessage(title, messageHtml, true);
    };

    var toastError = function(title, messageHtml) {
        toastMessage(title, messageHtml, false);
    };

    var messageId = "quickreload-flag";
    var toastMessage = function(title, messageHtml, isSuccess) {
        var auiFlag = tryGrabAuiFlag();
        if(auiFlag) {
            var flag = auiFlag({
                type: !!isSuccess ? "success" : "error",
                title: title,
                body: messageHtml,
                persistent: false,
                close: "auto"
            });

            setTimeout(flag.close, 1500);
        } else if(AJS.messages && $.isFunction(AJS.messages.success)) {
            var messageFunc;
            if(!!isSuccess) {
                messageFunc = AJS.messages.success;
            } else {
                messageFunc = AJS.messages.error;
            }

            var $message = $(messageFunc.call(AJS.messages, {
                title: title,
                body: messageHtml,
                id: messageId,
                fadeout: true,
                delay: 3000
            }));

            $("#" + messageId).remove();
            $("body").append($message);
        } else {
            alert(title);
        }
    };

    var contextPath = searchForContextPath();
    if(!contextPath) {
        console.warn("Failed to determine context path, QuickReload batch mode switcher not enabled");
        return;
    }

    var batchingEnabledState = false;
    //Fetch initial state
    $.get(getCurrentBatchModeStateUrl(contextPath)).done(function(data) {
        batchingEnabledState = data.batchingEnabled;
    });

    var throttledToggleBatchingCallback = throttle(function() {
        $.get(getUpdateBatchModeUrl(contextPath, !batchingEnabledState))
            .done(function(data) {
                batchingEnabledState = data.batchingEnabled;
                var successTitle = getToastSuccessTitle(batchingEnabledState);
                var successMessageHtml = getToastSuccessMessageHtml(batchingEnabledState);

                toastSuccess(successTitle, successMessageHtml);
            })
            .fail(function(xhr, textStatus) {
                if(textStatus !== "abort") {
                    var batchingStateStr = batchingEnabledState ? "enabled" : "disabled";

                    toastError("Failed to update batch mode state (current state: " + batchingStateStr + ")");
                }

            });
    }, 150, { trailing: false });

    AJS.whenIType("b").execute(throttledToggleBatchingCallback);
}

// We don't know what web resource to get jQuery from (because we could be anywhere in JIRA / Customer Portal / Confluence),
// so register this to run after page load with vanilla JavaScript.
document.addEventListener("DOMContentLoaded", function () {
    var jQuery = (window.AJS && AJS.$) || $;
    var AtlassianJavaScript = window.AJS;

    if (!jQuery) {
        console.error("Could not find jQuery, QuickReload batch mode switcher not enabled");
        return;
    }
    if (!AtlassianJavaScript) {
        console.error("Could not find AJS, QuickReload batch mode switcher not enabled");
        return;
    }
    if (!jQuery.isFunction(AtlassianJavaScript.whenIType)) {
        console.error("Could not find AJS.whenIType, QuickReload batch mode switcher not enabled");
        return;
    }

    quickReloadBatchModeSwitcherInit(jQuery, AtlassianJavaScript);
}, false);