/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.utils;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class Files {
    public static File smooshNames(String startingPath, String pathToAdd) {
        String smooshed = FilenameUtils.concat((String)startingPath, (String)pathToAdd);
        return new File(smooshed);
    }

    public static File smooshNames(File startingPath, String pathToAdd) {
        String smooshed = FilenameUtils.concat((String)startingPath.getAbsolutePath(), (String)pathToAdd);
        return new File(smooshed);
    }

    public static File smooshNames(File startingPath, File pathToAdd) {
        String smooshed = FilenameUtils.concat((String)startingPath.getAbsolutePath(), (String)pathToAdd.getAbsolutePath());
        return new File(smooshed);
    }

    public static void mkdirs(File file) {
        file.mkdirs();
    }

    public static File pwd() {
        return new File(new File("pwd").getAbsolutePath()).getParentFile();
    }

    public static void traverseUpLookingForFile(String fileName, File startingDir, Consumer<File> sideEffect) {
        for (File dir = startingDir; dir != null; dir = dir.getParentFile()) {
            File file = Files.smooshNames(dir, fileName);
            if (!file.exists() || !file.isFile()) continue;
            sideEffect.accept(file);
        }
    }

    public static void traverseUpLookingForFileExcludingEndingDir(String fileName, File startingDir, File endingDir, Consumer<File> sideEffect) {
        for (File dir = startingDir; dir != null && !dir.equals(endingDir); dir = dir.getParentFile()) {
            File file = Files.smooshNames(dir, fileName);
            if (!file.exists() || !file.isFile()) continue;
            sideEffect.accept(file);
        }
    }

    public static Optional<File> traverseUpForFileThenYouFindItAndTheCant(String fileName, File startingDir) {
        Optional<File> found = Files.traverseUpTillItsFound(fileName, startingDir);
        if (found.isPresent()) {
            return Files.traverseUpTillItsNotThere(found.get());
        }
        return found;
    }

    private static Optional<File> traverseUpTillItsFound(String fileName, File startingDir) {
        for (File dir = startingDir; dir != null; dir = dir.getParentFile()) {
            File file = Files.smooshNames(dir, fileName);
            if (!file.exists() || !file.isFile()) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private static Optional<File> traverseUpTillItsNotThere(File startingFile) {
        File file;
        if (!startingFile.isFile()) {
            throw new IllegalArgumentException();
        }
        Optional<File> lastFile = Optional.of(startingFile);
        String desiredName = startingFile.getName();
        for (File dir = startingFile.getParentFile().getParentFile(); dir != null && (file = Files.smooshNames(dir, desiredName)).exists() && file.isFile(); dir = dir.getParentFile()) {
            lastFile = Optional.of(file);
        }
        return lastFile;
    }

    public static void traverseDownLookingForFile(String fileName, File startingDir, Consumer<File> sideEffect) {
        Iterator iterator = FileUtils.iterateFiles((File)startingDir, (IOFileFilter)new NameFileFilter("pom.xml"), (IOFileFilter)TrueFileFilter.TRUE);
        while (iterator.hasNext()) {
            File next = (File)iterator.next();
            sideEffect.accept(next);
        }
    }

    public static boolean directoryExists(File potentialDir) {
        return potentialDir.exists() && potentialDir.isDirectory();
    }

    public static boolean pathContainsDirectory(File file, String targetName) {
        for (File f = file; f != null; f = f.getParentFile()) {
            if (!f.isDirectory() || !f.getName().equals(targetName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAtlassianPlugin(File jarFile) {
        try {
            JarFile jar = new JarFile(jarFile);
            ZipEntry entry = jar.getEntry("atlassian-plugin.xml");
            return entry != null && !entry.isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isSourceJar(File file) {
        return file.getName().endsWith("-sources.jar");
    }

    public static File getHomeDir() {
        return new File(System.getProperty("user.home"));
    }
}

