/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.labs.plugins.quickreload.DirectoryTracker;
import com.atlassian.labs.plugins.quickreload.DirectoryWatcher;
import com.atlassian.labs.plugins.quickreload.rest.Links;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json", "text/plain", "application/x-www-form-urlencoded"})
@Path(value="/tracked")
public class TrackedRestResource {
    private final DirectoryTracker directoryTracker;
    private final DirectoryWatcher directoryWatcher;

    @Inject
    public TrackedRestResource(DirectoryTracker directoryTracker, DirectoryWatcher directoryWatcher) {
        this.directoryTracker = directoryTracker;
        this.directoryWatcher = directoryWatcher;
    }

    @GET
    public Response getTracked(@Context UriInfo uriInfo) {
        return Response.ok((Object)this.tracked(uriInfo), (String)"application/json").build();
    }

    @POST
    @Path(value="/{directory : .+?}")
    public Response trackThis(@PathParam(value="directory") String directory, @Context UriInfo uriInfo) {
        if (StringUtils.isEmpty((CharSequence)directory)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new Error(this.api(uriInfo), "Directory not found")).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        File trackedDir = new File(directory);
        this.directoryTracker.add(trackedDir.getAbsolutePath());
        this.directoryWatcher.watch(trackedDir);
        return Response.ok((Object)this.tracked(uriInfo), (String)"application/json").build();
    }

    @DELETE
    @Path(value="/{directory : .+?}")
    public Response untrackThis(@PathParam(value="directory") String directory, @Context UriInfo uriInfo) {
        if (StringUtils.isEmpty((CharSequence)directory)) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new Error(this.api(uriInfo), "Directory not found")).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        File trackedDir = new File(directory);
        this.directoryTracker.remove(trackedDir);
        this.directoryWatcher.unwatch(trackedDir);
        return Response.ok((Object)this.tracked(uriInfo), (String)"application/json").build();
    }

    private Tracked tracked(UriInfo uriInfo) {
        List<String> tracked = this.directoryTracker.getTracked().stream().map(File::getAbsolutePath).sorted().collect(Collectors.toList());
        return new Tracked(this.api(uriInfo), tracked);
    }

    private Links.ApiLinks api(UriInfo uriInfo) {
        return Links.ApiLinks.builder(uriInfo).build();
    }

    static class Error {
        public final String error;
        public final Links.ApiLinks api;

        Error(Links.ApiLinks api, String error) {
            this.api = api;
            this.error = error;
        }
    }

    static class Tracked {
        public final Collection<String> directories;
        public final Links.ApiLinks api;

        Tracked(Links.ApiLinks api, Collection<String> directories) {
            this.api = api;
            this.directories = directories;
        }
    }
}

