/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.rest;

import com.atlassian.labs.plugins.quickreload.inspectors.BundleHeaderParser;
import com.atlassian.labs.plugins.quickreload.inspectors.BundleInspector;
import com.atlassian.labs.plugins.quickreload.inspectors.PluginBundle;
import com.atlassian.labs.plugins.quickreload.rest.Links;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.ISODateTimeFormat;
import org.osgi.framework.Bundle;
import org.springframework.context.ApplicationContext;

@AnonymousAllowed
@Produces(value={"application/json"})
@Consumes(value={"application/json", "text/plain", "application/x-www-form-urlencoded"})
@Path(value="/")
public class BundlesResource {
    private final BundleInspector bundleInspector;
    private static final Map<Integer, String> STATES = new HashMap<Integer, String>();

    @Inject
    public BundlesResource(BundleInspector bundleInspector) {
        this.bundleInspector = bundleInspector;
    }

    @GET
    @Path(value="/services")
    @AnonymousAllowed
    public Response getBundleServices(@Context UriInfo uriInfo) {
        return Response.ok((Object)this.bundleServices(uriInfo), (String)"application/json").build();
    }

    @GET
    @Path(value="/bundles")
    @AnonymousAllowed
    public Response getAllBundles(@Context UriInfo uriInfo) {
        return Response.ok((Object)this.bundles(uriInfo, pluginBundle -> true), (String)"application/json").build();
    }

    @GET
    @Path(value="/plugins")
    @AnonymousAllowed
    public Response getAllPlugins(@Context UriInfo uriInfo) {
        return Response.ok((Object)this.bundles(uriInfo, this.pluginsOnly()), (String)"application/json").build();
    }

    @GET
    @Path(value="/plugins/{pluginKey}")
    @AnonymousAllowed
    public Response getPlugin(@Context UriInfo uriInfo, @PathParam(value="pluginKey") String pluginKey) {
        Optional<SingleBundle> bundle = this.singlePlugin(uriInfo, pluginKey);
        if (bundle.isPresent()) {
            return Response.ok((Object)bundle.get(), (String)"application/json").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/html").build();
    }

    @GET
    @Path(value="/bundles/{bundleId : \\d+}")
    @AnonymousAllowed
    public Response getBundle(@Context UriInfo uriInfo, @PathParam(value="bundleId") long bundleId) {
        Optional<SingleBundle> bundle = this.singleBundle(uriInfo, bundleId);
        if (bundle.isPresent()) {
            return Response.ok((Object)bundle.get(), (String)"application/json").build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/html").build();
    }

    private Predicate<PluginBundle> pluginsOnly() {
        return PluginBundle::isAtlassianPlugin;
    }

    private AllBundles bundles(UriInfo uriInfo, Predicate<PluginBundle> predicate) {
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        this.bundleInspector.inspectBundles(pluginBundle -> {
            if (predicate.test(pluginBundle)) {
                Links.BundleLinks links = BundlesResource.createBundleLinks(uriInfo, pluginBundle.getBundle());
                BundleInfo bundleInfo = new BundleInfo(links, pluginBundle.getPluginKey(), pluginBundle.getBundle());
                bundles.add(bundleInfo);
            }
        });
        return new AllBundles(uriInfo, bundles);
    }

    private Optional<SingleBundle> singlePlugin(UriInfo uriInfo, String pluginKey) {
        Optional<PluginBundle> pluginBundle = this.bundleInspector.newPluginBundle(pluginKey);
        if (pluginBundle.isPresent()) {
            return this.singleBundle(uriInfo, pluginBundle.get().getBundle().getBundleId());
        }
        return Optional.empty();
    }

    private Optional<SingleBundle> singleBundle(UriInfo uriInfo, long bundleId) {
        final ArrayList<BeanInfo> beans = new ArrayList<BeanInfo>();
        final AtomicReference pluginBundleRef = new AtomicReference();
        final AtomicReference springContextRef = new AtomicReference();
        this.bundleInspector.inspectBundle(bundleId, new BundleInspector.BeanCallback(){

            @Override
            public void onStart(PluginBundle pluginBundle) {
                pluginBundleRef.set(pluginBundle);
            }

            @Override
            public void onSpringContext(ApplicationContext applicationContext) {
                springContextRef.set(applicationContext);
            }

            @Override
            public void onSpringBean(BundleInspector.BeanInspectionDefinition def) {
                Optional<String> beanClassGuess = def.bean().map(BundlesResource.this.bundleInspector::guessBeanClass);
                Optional<String> beanException = def.beanException().map(x$0 -> BundlesResource.this.makeExceptionStr(x$0));
                String[] beanAndClass = BundlesResource.this.beanAndClass(def.bean().orElse(null));
                BeanInfo bean = new BeanInfo(def.beanName(), beanAndClass[0], beanAndClass[1], beanClassGuess.orElse(null), beanException.orElse(null), def.singleton(), def.prototype());
                beans.add(bean);
            }
        });
        Collections.sort(beans);
        PluginBundle pluginBundle = (PluginBundle)pluginBundleRef.get();
        if (pluginBundle == null) {
            return Optional.empty();
        }
        Bundle bundle = pluginBundle.getBundle();
        Services offeredServices = this.buildOfferedServices(uriInfo, bundle);
        Services consumedServices = this.buildConsumedServices(uriInfo, bundle);
        FullBundleInfo bundleInfo = new FullBundleInfo(uriInfo, pluginBundle.getPluginKey(), bundle, offeredServices, consumedServices);
        SpringInfo springInfo = null;
        Optional applicationContext = Optional.ofNullable(springContextRef.get());
        if (applicationContext.isPresent()) {
            springInfo = new SpringInfo((ApplicationContext)applicationContext.get(), beans);
        }
        ArrayList<ModuleInfo> modules = new ArrayList<ModuleInfo>();
        Optional<Plugin> plugin = this.bundleInspector.inspectBundlePluginModules(bundleId, (moduleDescriptor, enabled) -> modules.add(this.toModuleInfo(uriInfo, moduleDescriptor)));
        PluginInfo pluginInfo = null;
        if (plugin.isPresent()) {
            pluginInfo = this.toPluginInfo(uriInfo, plugin.get(), modules);
        }
        return Optional.of(new SingleBundle(uriInfo, BundlesResource.buildBundleDescriptiveName(bundle), bundleInfo, springInfo, pluginInfo));
    }

    private String[] beanAndClass(Object bean) {
        try {
            return new String[]{String.valueOf(bean), bean == null ? "null" : bean.getClass().getName()};
        }
        catch (Exception e) {
            return new String[]{e.toString(), e.getClass().getName()};
        }
    }

    private AllServices bundleServices(UriInfo uriInfo) {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        this.bundleInspector.inspectBundleServices((pluginBundle, service) -> services.add(this.toServiceInfo(uriInfo, true, true).apply(service)));
        return new AllServices(uriInfo, services);
    }

    private PluginInfo toPluginInfo(UriInfo uriInfo, Plugin p2, List<ModuleInfo> modules) {
        PluginInformation information = p2.getPluginInformation();
        PluginInfo pluginInfo = new PluginInfo(p2.getKey(), p2.getName(), information.getDescription(), information.getVersion(), information.getVendorName(), this.bundleInspector.isEnabled(p2), this.bundleInspector.isSystemPlugin(p2), this.createPluginLinks(p2, uriInfo), modules);
        return pluginInfo;
    }

    private ModuleInfo toModuleInfo(UriInfo uriInfo, ModuleDescriptor<?> moduleDescriptor) {
        return new ModuleInfo(moduleDescriptor.getCompleteKey(), moduleDescriptor.getName(), moduleDescriptor.getDescription(), moduleDescriptor.getClass().getName(), String.valueOf(moduleDescriptor.getModuleClass()), true, this.createModuleLinks(moduleDescriptor, uriInfo));
    }

    private Links.ModuleLinks createModuleLinks(ModuleDescriptor<?> moduleDescriptor, UriInfo uriInfo) {
        return Links.ModuleLinks.builder(uriInfo).withModuleKey(moduleDescriptor.getCompleteKey()).withPluginKey(moduleDescriptor.getPluginKey()).build();
    }

    private Links.PluginLinks createPluginLinks(Plugin p2, UriInfo uriInfo) {
        return Links.PluginLinks.builder(uriInfo).withPluginKey(p2.getKey()).build();
    }

    private static String buildBundleDescriptiveName(Bundle bundle) {
        return String.format("%s - %s (%d)", bundle.getHeaders().get("Bundle-Name"), bundle.getSymbolicName(), bundle.getBundleId());
    }

    private static String buildBundleName(Bundle bundle) {
        Object name = bundle.getHeaders().get("Bundle-Name");
        return Objects.toString(name, bundle.getSymbolicName());
    }

    private Services buildOfferedServices(UriInfo uriInfo, Bundle bundle) {
        List<BundleInspector.ServiceRef> serviceRefs = this.bundleInspector.inspectRegisteredServices(bundle);
        Collection services = serviceRefs.stream().map(this.toServiceInfo(uriInfo, false, true)).collect(Collectors.toList());
        Collection servicesSummary = serviceRefs.stream().map(this.toServiceSummary()).collect(Collectors.toList());
        return new Services(servicesSummary, services);
    }

    private Services buildConsumedServices(UriInfo uriInfo, Bundle bundle) {
        List<BundleInspector.ServiceRef> serviceRefs = this.bundleInspector.inspectServicesInUse(bundle);
        Collection services = serviceRefs.stream().map(this.toServiceInfo(uriInfo, true, false)).collect(Collectors.toList());
        Collection servicesSummary = serviceRefs.stream().map(this.toServiceSummary()).collect(Collectors.toList());
        return new Services(servicesSummary, services);
    }

    private Function<BundleInspector.ServiceRef, ServiceInfo> toServiceInfo(UriInfo uriInfo, boolean includeOfferingBundles, boolean includeUsingBundles) {
        return from -> {
            Links.BundleLinks offeringBundle = null;
            if (includeOfferingBundles) {
                offeringBundle = this.toBundleLinks(uriInfo).apply(from.offeringBundle);
            }
            Collection usingLinks = null;
            if (includeUsingBundles) {
                usingLinks = from.usingBundles.stream().map(this.toBundleLinks(uriInfo)).collect(Collectors.toList());
            }
            return new ServiceInfo(from.serviceId, from.objectClasses, offeringBundle, from.serviceProperties, usingLinks);
        };
    }

    private Function<BundleInspector.ServiceRef, String> toServiceSummary() {
        return from -> from.serviceId + " - " + StringUtils.join(from.objectClasses, (String)",");
    }

    private Function<Bundle, Links.BundleLinks> toBundleLinks(UriInfo uriInfo) {
        return from -> BundlesResource.createBundleLinks(uriInfo, from);
    }

    private String makeExceptionStr(Exception from) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        from.printStackTrace(pw);
        return sw.toString();
    }

    static Links.BundleLinks createBundleLinks(UriInfo uriInfo, Bundle bundle) {
        return Links.BundleLinks.builder(uriInfo).withName(BundlesResource.buildBundleDescriptiveName(bundle)).withBundleId(bundle.getBundleId()).withPluginKey(BundleInspector.getPluginKey(bundle)).build();
    }

    static {
        STATES.put(32, "ACTIVE");
        STATES.put(2, "INSTALLED");
        STATES.put(4, "RESOLVED");
        STATES.put(8, "STARTING");
        STATES.put(16, "STOPPING");
        STATES.put(1, "UNINSTALLED");
    }

    static class BeanInfo
    implements Comparable<BeanInfo> {
        public final String beanName;
        public final String bean;
        public final String beanClass;
        public final String beanClassGuess;
        public final String beanException;
        public final boolean singleton;
        public final boolean prototype;

        BeanInfo(String beanName, String bean, String beanClass, String beanClassGuess, String beanException, boolean singleton, boolean prototype) {
            this.beanName = beanName;
            this.bean = bean == null ? null : String.valueOf(bean);
            this.beanClass = beanClass;
            this.beanClassGuess = beanClassGuess;
            this.beanException = beanException;
            this.singleton = singleton;
            this.prototype = prototype;
        }

        @Override
        public int compareTo(BeanInfo o) {
            return this.beanName.compareTo(o.beanName);
        }
    }

    static class SpringInfo {
        public final String id;
        public final String displayName;
        public final String startDate;
        public final int beanCount;
        public final Collection<BeanInfo> beans;

        SpringInfo(ApplicationContext applicationContext, Collection<BeanInfo> beans) {
            this.id = applicationContext.getId();
            this.displayName = applicationContext.getDisplayName();
            this.startDate = ISODateTimeFormat.dateTime().print(applicationContext.getStartupDate());
            this.beanCount = beans.size();
            this.beans = beans;
        }
    }

    static class ModuleInfo {
        public final String completeKey;
        public final String name;
        public final String description;
        public final String moduleDescriptorClass;
        public final String moduleClass;
        public final boolean enabled;
        public final Links.ModuleLinks moduleLinks;

        ModuleInfo(String completeKey, String name, String description, String moduleDescriptorClass, String moduleClass, boolean enabled, Links.ModuleLinks moduleLinks) {
            this.completeKey = completeKey;
            this.name = name;
            this.description = description;
            this.moduleDescriptorClass = moduleDescriptorClass;
            this.moduleClass = moduleClass;
            this.enabled = enabled;
            this.moduleLinks = moduleLinks;
        }
    }

    static class PluginInfo {
        public final String pluginKey;
        public final String name;
        public final String description;
        public final String version;
        public final boolean enabled;
        public final String vendor;
        public final boolean systemPlugin;
        public final Collection<ModuleInfo> modules;
        public final Links.PluginLinks links;

        PluginInfo(String pluginKey, String name, String description, String version, String vendor, boolean enabled, boolean systemPlugin, Links.PluginLinks links, Collection<ModuleInfo> modules) {
            this.pluginKey = pluginKey;
            this.name = name;
            this.description = description;
            this.version = version;
            this.vendor = vendor;
            this.enabled = enabled;
            this.systemPlugin = systemPlugin;
            this.links = links;
            this.modules = modules;
        }
    }

    static class FullBundleInfo {
        public final long bundleId;
        public final String name;
        public final String version;
        public final String state;
        public final String bundleSymbolicName;
        public final String pluginKey;
        public final String location;
        public final Services offeredServices;
        public final Services consumedServices;
        public final Collection<BundleHeaderParser.ParsedHeader> parsedHeaders;
        public final Map<String, String> simpleHeaders;
        public final Links.BundleLinks links;

        FullBundleInfo(UriInfo uriInfo, String pluginKey, Bundle bundle, Services offeredServices, Services consumedServices) {
            this.links = BundlesResource.createBundleLinks(uriInfo, bundle);
            this.pluginKey = pluginKey;
            this.name = BundlesResource.buildBundleName(bundle);
            this.bundleSymbolicName = bundle.getSymbolicName();
            this.bundleId = bundle.getBundleId();
            this.location = bundle.getLocation();
            this.version = bundle.getVersion().toString();
            this.state = (String)STATES.get(bundle.getState());
            this.parsedHeaders = BundleHeaderParser.getParseableHeaders(bundle);
            this.simpleHeaders = BundleHeaderParser.getSimpleHeaders(bundle);
            this.offeredServices = offeredServices;
            this.consumedServices = consumedServices;
        }
    }

    static class Services {
        public final Collection<String> servicesSummary;
        public final Collection<ServiceInfo> services;

        Services(Collection<String> servicesSummary, Collection<ServiceInfo> services) {
            this.servicesSummary = servicesSummary;
            this.services = services;
        }
    }

    static class ServiceInfo {
        public final String serviceId;
        public final Collection<String> objectClasses;
        public final Map<String, String> serviceProperties;
        public final Links.BundleLinks offeringBundle;
        public final Collection<Links.BundleLinks> usingBundles;

        ServiceInfo(String serviceId, Collection<String> objectClasses, Links.BundleLinks offeringBundle, Map<String, String> serviceProperties, Collection<Links.BundleLinks> usingBundles) {
            this.serviceId = serviceId;
            this.objectClasses = objectClasses;
            this.offeringBundle = offeringBundle;
            this.serviceProperties = serviceProperties;
            this.usingBundles = usingBundles;
        }
    }

    static class BundleInfo
    implements Comparable<BundleInfo> {
        public final long bundleId;
        public final String name;
        public final String version;
        public final String state;
        public final String bundleSymbolicName;
        public final String pluginKey;
        public final String location;
        public final Links.BundleLinks links;

        BundleInfo(Links.BundleLinks links, String pluginKey, Bundle bundle) {
            this.links = links;
            this.pluginKey = pluginKey;
            this.name = BundlesResource.buildBundleName(bundle);
            this.bundleSymbolicName = bundle.getSymbolicName();
            this.bundleId = bundle.getBundleId();
            this.location = bundle.getLocation();
            this.version = bundle.getVersion().toString();
            this.state = (String)STATES.get(bundle.getState());
        }

        @Override
        public int compareTo(BundleInfo o) {
            return Long.compare(this.bundleId, o.bundleId);
        }
    }

    static class SingleBundle {
        public final String name;
        public final SpringInfo springInfo;
        public final FullBundleInfo bundleInfo;
        public final PluginInfo pluginInfo;
        public final Links.ApiLinks api;

        SingleBundle(UriInfo uriInfo, String name, FullBundleInfo bundleInfo, SpringInfo springInfo, PluginInfo pluginInfo) {
            this.name = name;
            this.pluginInfo = pluginInfo;
            this.api = Links.ApiLinks.builder(uriInfo).build();
            this.bundleInfo = bundleInfo;
            this.springInfo = springInfo;
        }
    }

    static class AllBundles {
        public final Collection<BundleInfo> bundles;
        public final Links.ApiLinks api;

        AllBundles(UriInfo uriInfo, Collection<BundleInfo> bundles) {
            this.api = Links.ApiLinks.builder(uriInfo).build();
            this.bundles = bundles;
        }
    }

    static class AllServices {
        public final Collection<ServiceInfo> serviceInfo;
        public final Links.ApiLinks api;

        AllServices(UriInfo uriInfo, Collection<ServiceInfo> services) {
            this.api = Links.ApiLinks.builder(uriInfo).build();
            this.serviceInfo = services;
        }
    }
}

