/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload.config;

import com.atlassian.labs.plugins.quickreload.DirectoryTracker;
import com.atlassian.labs.plugins.quickreload.LifecycledComponent;
import com.atlassian.labs.plugins.quickreload.QrConfiguration;
import com.atlassian.labs.plugins.quickreload.StateManager;
import com.atlassian.labs.plugins.quickreload.config.BasicConfigFileReader;
import com.atlassian.labs.plugins.quickreload.config.PomConventionStrategy;
import com.atlassian.labs.plugins.quickreload.utils.Files;
import com.atlassian.labs.plugins.quickreload.utils.LogLeveller;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ConfigReader
implements LifecycledComponent {
    private static final Logger log = LogLeveller.setInfo(LoggerFactory.getLogger(ConfigReader.class));
    private static final String LEGACY_HOME_FILE = "/.quickreload/quickreload";
    private static final String HOME_FILE = "/.quickreload";
    private static final String QUICKRELOAD_TRACK = "quickreload.tracked";
    private static final String LEGACY_DOT_QUICKRELOAD = ".quickreload";
    private static final String QR_DOT_PROPERTIES = "quickreload.properties";
    private static final String START_DISCOVER_REPO_ROOT_FROM_DIR = "quick.reload.discovery.startDir";
    private final DirectoryTracker directoryTracker;
    private final QrConfiguration qrConfiguration;
    private final StateManager stateManager;

    @Inject
    public ConfigReader(DirectoryTracker directoryTracker, QrConfiguration qrConfiguration, StateManager stateManager) {
        this.directoryTracker = directoryTracker;
        this.qrConfiguration = qrConfiguration;
        this.stateManager = stateManager;
    }

    @Override
    public void onStartup() {
        this.reReadConfiguration();
    }

    public void onRefresh() {
        this.reReadConfiguration();
    }

    private void reReadConfiguration() {
        this.runPomXmlConvention();
        File homeFile = this.getHomeConfigurationFile();
        this.readConfigFile(homeFile, ConfigFileMode.GLOBAL);
        File homeDotQuickReload = this.getSecondLegacyConfigurationFile();
        this.readConfigFile(homeDotQuickReload, ConfigFileMode.GLOBAL);
        homeDotQuickReload = this.getFirstLegacyConfigurationFile();
        this.readConfigFile(homeDotQuickReload, ConfigFileMode.GLOBAL);
        this.findLocalConfig();
        this.readSystemProperty();
        this.directoryTracker.refinedTrackedDirsList();
        this.applyQrConfigChanges();
    }

    private File getLocationToStartLookingForRepoRoot() {
        String startDiscoverfrom = System.getProperty(START_DISCOVER_REPO_ROOT_FROM_DIR);
        if (!StringUtils.isEmpty((CharSequence)startDiscoverfrom)) {
            return new File(startDiscoverfrom);
        }
        return Files.pwd();
    }

    private void runPomXmlConvention() {
        PomConventionStrategy strategy = new PomConventionStrategy(this.getLocationToStartLookingForRepoRoot());
        List<File> targetDirs = strategy.getTargetDirs();
        for (File dir : targetDirs) {
            this.directoryTracker.add(dir);
        }
    }

    public File getFirstLegacyConfigurationFile() {
        return this.readHomeFile(LEGACY_HOME_FILE, FileCreation.NO_CREATE);
    }

    public File getSecondLegacyConfigurationFile() {
        return this.readHomeFile(HOME_FILE, FileCreation.NO_CREATE);
    }

    public File getHomeConfigurationFile() {
        return this.readHomeFile(QR_DOT_PROPERTIES, FileCreation.CREATE_WITH_DEFAULTS);
    }

    private File readHomeFile(String homeFile, FileCreation create) {
        File userHome = Files.getHomeDir();
        File configFile = new File(userHome, homeFile);
        if (create == FileCreation.CREATE_WITH_DEFAULTS && !configFile.exists()) {
            this.touch(configFile);
        }
        return configFile;
    }

    private void findLocalConfig() {
        Consumer<File> sideEffect = dotQuickReload -> this.readConfigFile((File)dotQuickReload, ConfigFileMode.LOCAL);
        Files.traverseUpLookingForFileExcludingEndingDir(LEGACY_DOT_QUICKRELOAD, Files.pwd(), Files.getHomeDir(), sideEffect);
        Files.traverseUpLookingForFileExcludingEndingDir(QR_DOT_PROPERTIES, Files.pwd(), Files.getHomeDir(), sideEffect);
    }

    public List<File> getLocalQRConfigFiles() {
        ArrayList<File> files = new ArrayList<File>();
        Files.traverseUpLookingForFileExcludingEndingDir(QR_DOT_PROPERTIES, Files.pwd(), Files.getHomeDir(), files::add);
        return files;
    }

    private void applyQrConfigChanges() {
        this.qrConfiguration.getFlag("webresourcebatching").ifPresent(batchingDesiredState -> {
            boolean batchingCurrentState = this.stateManager.isBatchingEnabled();
            if (batchingDesiredState != batchingCurrentState) {
                if (batchingDesiredState.booleanValue()) {
                    this.stateManager.enableBatching();
                } else {
                    this.stateManager.disableBatching();
                }
            }
        });
    }

    @Override
    public void onShutdown() {
    }

    private void readSystemProperty() {
        String[] dirs;
        String quickReloadDirs = StringUtils.defaultString((String)System.getProperty(QUICKRELOAD_TRACK));
        for (String entry : dirs = StringUtils.split((String)quickReloadDirs, (String)",")) {
            this.processDirectoryEntry(Optional.of(Files.pwd()), entry);
        }
    }

    private void touch(File trackedDirList) {
        try {
            Files.mkdirs(trackedDirList.getParentFile());
            FileUtils.touch((File)trackedDirList);
            try (FileWriter out = new FileWriter(trackedDirList);){
                out.write("#\n# Quick Reload Config File\n# ------------------------------\n#\n# Add directories to this file, one on each line, and the quick reload support will monitor them\n# and automatically load them as soon as they are compiled and assembled.\n#\n# Directories can be relative to this configuration file and hence allow directories outside\n# your project to be monitored and reloaded.#\n# You can use -Dquickreload.dirs=dir1,dir2,dir3 on the JVM command line to also specify directories\n# to monitor.\n#\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readConfigFile(File configFile, ConfigFileMode configMode) {
        Optional<File> interpretRelativeToDir = Optional.of(configFile.getParentFile());
        List<String> fileEntries = this.readConfigFileEntries(configFile);
        if (configMode == ConfigFileMode.LOCAL && configFile.exists() && configFile.isFile() && fileEntries.size() == 0) {
            this.directoryTracker.add(configFile.getParentFile().getAbsolutePath(), Optional.empty(), Collections.emptyMap());
        }
        for (String entry : fileEntries) {
            this.processDirectoryEntry(interpretRelativeToDir, entry);
        }
    }

    private void processDirectoryEntry(Optional<File> interpretRelativeToDir, String entry) {
        ConfigEntry configEntry = this.parseEntry(entry);
        if (configEntry.isQrConfigEntry()) {
            this.qrConfiguration.addConfiguration(configEntry.getQrConfigProperties());
        } else {
            String path = configEntry.path;
            Map<String, String> mapOfProperties = configEntry.getPathProperties();
            Optional<String> resourceEntry = Optional.ofNullable(mapOfProperties.get("resource"));
            if (resourceEntry.isPresent()) {
                this.directoryTracker.addResourceEntry(path, interpretRelativeToDir);
            } else if (path.startsWith("!")) {
                path = StringUtils.substringAfter((String)path, (String)"!").trim();
                this.directoryTracker.removeFromTrackedAndBlacklistThisDir(path, interpretRelativeToDir, configEntry.getQrConfigProperties());
            } else {
                this.directoryTracker.add(path, interpretRelativeToDir, mapOfProperties);
            }
        }
    }

    ConfigEntry parseEntry(String entry) {
        if ((entry = StringUtils.trim((String)entry)).matches("^qr\\s*:.*")) {
            entry = StringUtils.substringAfter((String)entry, (String)":");
            Map<String, String> qrProperties = this.parseProperties(entry);
            return new ConfigEntry(null, Collections.emptyMap(), qrProperties);
        }
        String path = StringUtils.trim((String)entry);
        String propertiesEntry = "";
        if (StringUtils.contains((CharSequence)entry, (int)58)) {
            path = StringUtils.trim((String)StringUtils.substringAfter((String)entry, (String)":"));
            propertiesEntry = StringUtils.substringBefore((String)entry, (String)":");
        }
        Map<String, String> properties = this.parseProperties(propertiesEntry);
        return new ConfigEntry(path, properties, Collections.emptyMap());
    }

    private Map<String, String> parseProperties(String propertiesEntry) {
        if (StringUtils.isNotBlank((CharSequence)propertiesEntry)) {
            String[] values;
            HashMap<String, String> properties = new HashMap<String, String>();
            for (String value : values = StringUtils.split((String)propertiesEntry, (String)";")) {
                if (StringUtils.startsWith((CharSequence)(value = StringUtils.trim((String)value)), (CharSequence)"=")) continue;
                String[] keyValues = StringUtils.split((String)value, (String)"=");
                if (keyValues.length == 1 && StringUtils.isNotBlank((CharSequence)keyValues[0])) {
                    properties.put(StringUtils.trim((String)keyValues[0]), "true");
                }
                if (keyValues.length != 2 || !StringUtils.isNotBlank((CharSequence)keyValues[0])) continue;
                properties.put(StringUtils.trim((String)keyValues[0]), StringUtils.trim((String)keyValues[1]));
            }
            return properties;
        }
        return Collections.emptyMap();
    }

    private List<String> readConfigFileEntries(File configFile) {
        try {
            return new BasicConfigFileReader().readConfigFileEntries(configFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            log.info(String.format("Unable to read file %s.  No plugins will be automatically tracked", configFile));
        }
        return Collections.emptyList();
    }

    public static class ConfigEntry {
        private final String path;
        private final Map<String, String> pathProperties;
        private final Map<String, String> qrConfigProperties;

        public ConfigEntry(String path, Map<String, String> pathProperties, Map<String, String> qrConfigProperties) {
            this.path = path;
            this.pathProperties = pathProperties;
            this.qrConfigProperties = qrConfigProperties;
        }

        public boolean isQrConfigEntry() {
            return this.qrConfigProperties.size() > 0;
        }

        public String getPath() {
            return this.path;
        }

        public Map<String, String> getPathProperties() {
            return this.pathProperties;
        }

        public Map<String, String> getQrConfigProperties() {
            return this.qrConfigProperties;
        }
    }

    private static enum ConfigFileMode {
        LOCAL,
        GLOBAL;

    }

    private static enum FileCreation {
        CREATE_WITH_DEFAULTS,
        NO_CREATE;

    }
}

