/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import com.atlassian.labs.plugins.quickreload.cache.WebResourceUrlFlusher;
import com.atlassian.labs.plugins.quickreload.utils.LogLeveller;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class StateManager {
    public static final String PLUGIN_WEBRESOURCE_BATCHING_OFF = "plugin.webresource.batching.off";
    public static final String ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    public static final String JIRA_DEV_MODE = "jira.dev.mode";
    public static final String JIRA_CONTEXT_BATCHING_DISABLED = "jira.contextbatching.disabled";
    public static final String CONFLUENCE_DEV_MODE = "confluence.devmode";
    public static final String CONFLUENCE_CONTEXT_BATCHING_OFF = "confluence.context.batching.disable";
    private static final List<BatchingSystemProperty> batchingModeSystemProperties = Collections.unmodifiableList(Arrays.asList(new BatchingSystemProperty("plugin.webresource.batching.off", false), new BatchingSystemProperty("atlassian.dev.mode", false), new BatchingSystemProperty("jira.dev.mode", false), new BatchingSystemProperty("jira.contextbatching.disabled", false), new BatchingSystemProperty("confluence.devmode", false), new BatchingSystemProperty("confluence.context.batching.disable", false)));
    private static final Logger log = LogLeveller.setInfo(LoggerFactory.getLogger(StateManager.class));
    private final WebResourceUrlFlusher resourceUrlFlusher;
    private volatile boolean quickReloadEnabled = true;

    @Autowired
    public StateManager(WebResourceUrlFlusher resourceUrlFlusher) {
        this.resourceUrlFlusher = resourceUrlFlusher;
    }

    public boolean isQuickReloadEnabled() {
        return this.quickReloadEnabled;
    }

    public void enableQuickReload() {
        this.quickReloadEnabled = true;
    }

    public void disableQuickReload() {
        this.quickReloadEnabled = false;
    }

    public boolean isBatchingEnabled() {
        String batchingOff = System.getProperty(PLUGIN_WEBRESOURCE_BATCHING_OFF);
        return Boolean.valueOf(batchingOff) == false;
    }

    public void enableBatching() {
        this.setProperties(true);
        this.resourceUrlFlusher.flushWebResourceUrls();
        log.info("Fast mode - web resource batching is now ENABLED, dev mode DISABLED");
    }

    public void disableBatching() {
        this.setProperties(false);
        this.resourceUrlFlusher.flushWebResourceUrls();
        log.info("Dev mode - web resource batching is now DISABLED");
    }

    private void setProperties(boolean batchingEnabled) {
        for (BatchingSystemProperty property : batchingModeSystemProperties) {
            if (batchingEnabled) {
                System.setProperty(property.key, String.valueOf(property.valueForBatchingEnabled));
                continue;
            }
            System.setProperty(property.key, String.valueOf(!property.valueForBatchingEnabled));
        }
    }

    public Map<String, String> getBatchingSystemPropertyStates() {
        LinkedHashMap<String, String> states = new LinkedHashMap<String, String>();
        for (BatchingSystemProperty batchingSystemProperty : batchingModeSystemProperties) {
            String key = batchingSystemProperty.key;
            String value = System.getProperty(key);
            if (value == null) continue;
            states.put(key, value);
        }
        return Collections.unmodifiableMap(states);
    }

    private static class BatchingSystemProperty {
        public final String key;
        public final boolean valueForBatchingEnabled;

        public BatchingSystemProperty(String key, boolean valueForBatchingEnabled) {
            this.key = key;
            this.valueForBatchingEnabled = valueForBatchingEnabled;
        }
    }
}

