/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.labs.plugins.quickreload;

import com.atlassian.labs.plugins.quickreload.DirectoryWatcher;
import com.atlassian.labs.plugins.quickreload.SystemProperties;
import com.atlassian.labs.plugins.quickreload.utils.Files;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DirectoryTracker {
    private static final Logger log = LoggerFactory.getLogger(DirectoryWatcher.class);
    public static final String PLUGIN_RESOURCE_DIRECTORIES = "plugin.resource.directories";
    public static final String RESOURCE_COLON = "resource:";
    private final Set<File> trackedDirs = new TreeSet<File>();
    private final Set<File> notToTrackedDirs = new TreeSet<File>();
    private final Map<File, Map<String, String>> directoryProperties = new HashMap<File, Map<String, String>>();

    public Set<File> getTracked() {
        return new HashSet<File>(this.trackedDirs);
    }

    public boolean isTracked(File directory) {
        return this.trackedDirs.contains(directory);
    }

    public DirectoryTracker remove(File trackedDir) {
        return this.removeFromTrackedAndBlacklistThisDir(trackedDir.getAbsolutePath(), Optional.empty(), new HashMap<String, String>());
    }

    public DirectoryTracker add(String directoryName) {
        return this.add(directoryName, Optional.empty(), Collections.emptyMap());
    }

    public DirectoryTracker add(File dir) {
        return this.add(dir.getAbsolutePath(), Optional.empty(), Collections.emptyMap());
    }

    public DirectoryTracker add(String directoryName, Optional<File> parentDir, Map<String, String> properties) {
        File directory = Files.smooshNames(parentDir.orElseGet(() -> new File(".")), directoryName);
        if (!this.isBlackListed(directoryName)) {
            File targetDir = Files.smooshNames(directory, "./target");
            File resourcesDir = this.getResourceDirectory(directory, properties);
            if (this.isValidResourceDirectory(directory, resourcesDir)) {
                this.trackedDirs.add(targetDir);
                this.directoryProperties.put(targetDir, properties);
                this.addResourceDir(resourcesDir);
            } else {
                this.trackedDirs.add(directory);
                this.directoryProperties.put(targetDir, properties);
            }
        }
        return this;
    }

    public DirectoryTracker removeFromTrackedAndBlacklistThisDir(String directoryName, Optional<File> parentDir, Map<String, String> properties) {
        this.blackListDirectory(directoryName);
        File directory = Files.smooshNames(parentDir.orElseGet(() -> new File(".")), directoryName);
        File targetDir = Files.smooshNames(directory, "./target");
        File resourcesDir = this.getResourceDirectory(directory, properties);
        if (this.isValidResourceDirectory(directory, resourcesDir)) {
            this.trackedDirs.remove(targetDir);
            this.directoryProperties.remove(targetDir);
            this.removeResourceDir(resourcesDir);
        } else {
            this.trackedDirs.remove(directory);
            this.directoryProperties.remove(targetDir);
        }
        return this;
    }

    private boolean hasPomFile(File directory) {
        File pomFile = Files.smooshNames(directory, "./pom.xml");
        return pomFile.exists() && !pomFile.isDirectory();
    }

    public void addResourceEntry(String dirName, Optional<File> parentDir) {
        String newDirName = StringUtils.remove((String)dirName, (String)RESOURCE_COLON);
        if (parentDir.isPresent()) {
            this.addResourceDir(Files.smooshNames(parentDir.get(), newDirName));
        } else {
            this.addResourceDir(new File(newDirName));
        }
    }

    public void blackListDirectory(String directory) {
        log.warn("Adding " + directory + " to NOT TO WATCH list");
        this.notToTrackedDirs.add(new File(directory));
    }

    public boolean isBlackListed(String directory) {
        return this.isBlackListed(new File(directory));
    }

    public boolean isBlackListed(File file) {
        for (File notToTrackDir : this.notToTrackedDirs) {
            if (!notToTrackDir.equals(file)) continue;
            return true;
        }
        return false;
    }

    private void addResourceDir(File resourcesDir) {
        Set<String> alternateResourceDirs = this.getSystemResourceDirs();
        alternateResourceDirs.add(resourcesDir.getAbsolutePath());
        this.setSystemResourceDirs(alternateResourceDirs);
    }

    private void removeResourceDir(File resourcesDir) {
        Set<String> alternateResourceDirs = this.getSystemResourceDirs();
        alternateResourceDirs.remove(resourcesDir.getAbsolutePath());
        this.setSystemResourceDirs(alternateResourceDirs);
    }

    private Set<String> getSystemResourceDirs() {
        return new HashSet<String>(SystemProperties.getSystemPropertySplit(PLUGIN_RESOURCE_DIRECTORIES, ","));
    }

    private void setSystemResourceDirs(Set<String> alternateResourceDirs) {
        SystemProperties.setSystemProperty(PLUGIN_RESOURCE_DIRECTORIES, alternateResourceDirs, ',');
    }

    private File getResourceDirectory(File parentDirectory, Map<String, String> properties) {
        if (properties.containsKey("alternateResources")) {
            return Files.smooshNames(parentDirectory, properties.get("alternateResources"));
        }
        return Files.smooshNames(parentDirectory, "./src/main/resources");
    }

    private boolean isValidResourceDirectory(File parentDirectory, File resourceDirectory) {
        return this.hasPomFile(parentDirectory) && Files.directoryExists(resourceDirectory);
    }

    public void refinedTrackedDirsList() {
        for (File f : this.getTracked()) {
            if (!this.isBlackListed(f)) continue;
            this.remove(f);
        }
    }
}

