/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.ext;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.WatchService;
import name.pachler.nio.file.impl.BSDPathWatchService;
import name.pachler.nio.file.impl.LinuxPathWatchService;
import name.pachler.nio.file.impl.PathImpl;
import name.pachler.nio.file.impl.PathWatchService;
import name.pachler.nio.file.impl.PollingPathWatchService;
import name.pachler.nio.file.impl.WindowsPathWatchService;

public class Bootstrapper {
    private static final int OSTYPE_UNKNOWN = 0;
    private static final int OSTYPE_LINUX = 1;
    private static final int OSTYPE_WINDOWS = 2;
    private static final int OSTYPE_BSD = 3;
    private static boolean forcePolling = false;
    private static long defaultPollingInterval = 2000L;
    private static final int ostype;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WatchService newWatchService() {
        PathWatchService ws = null;
        try {
            if (!forcePolling) {
                switch (ostype) {
                    case 1: {
                        ws = new LinuxPathWatchService();
                    }
                    case 2: {
                        ws = new WindowsPathWatchService();
                    }
                    case 3: {
                        ws = new BSDPathWatchService();
                        return ws;
                    }
                    default: 
                }
            }
        }
        catch (Throwable t) {
            Logger.getLogger(Bootstrapper.class.getName()).log(Level.WARNING, null, t);
        }
        finally {
            if (ws == null) {
                ws = new PollingPathWatchService();
            }
            return ws;
        }
    }

    public static Path newPath(File file) {
        return new PathImpl(file);
    }

    public static File pathToFile(Path path) {
        return ((PathImpl)path).getFile();
    }

    public static boolean isForcePollingEnabled() {
        return forcePolling;
    }

    public static void setForcePollingEnabled(boolean forcePollingEnabled) {
        forcePolling = forcePollingEnabled;
    }

    public static void setDefaultPollingInterval(long pollInterval) {
        if (pollInterval <= 0L) {
            throw new IllegalArgumentException("polling interval must be greater than zero");
        }
        defaultPollingInterval = pollInterval;
    }

    public static long getDefaultPollingInterval() {
        return defaultPollingInterval;
    }

    static {
        String osName = System.getProperty("os.name");
        ostype = osName.contains("Windows") ? 2 : (osName.equals("Linux") ? 1 : (osName.equals("Mac OS X") || osName.equals("FreeBSD") ? 3 : 0));
    }
}

