/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.websocket.drafts;

import com.netiq.websocket.Draft;
import com.netiq.websocket.HandshakeBuilder;
import com.netiq.websocket.Handshakedata;
import com.netiq.websocket.HandshakedataImpl1;
import com.netiq.websocket.drafts.Draft_75;
import com.netiq.websocket.exceptions.InvalidHandshakeException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;

public class Draft_76
extends Draft_75 {
    private HandshakeBuilder builder = null;
    private boolean failed = false;

    public static byte[] createChallenge(String key1, String key2, byte[] key3) throws InvalidHandshakeException {
        MessageDigest md5;
        byte[] part1 = Draft_76.getPart(key1);
        byte[] part2 = Draft_76.getPart(key2);
        byte[] challenge = new byte[]{part1[0], part1[1], part1[2], part1[3], part2[0], part2[1], part2[2], part2[3], key3[0], key3[1], key3[2], key3[3], key3[4], key3[5], key3[6], key3[7]};
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return md5.digest(challenge);
    }

    private static String generateKey() {
        int position;
        int i;
        Random r = new Random();
        long maxNumber = 0xFFFFFFFFL;
        long spaces = r.nextInt(12) + 1;
        int max = new Long(maxNumber / spaces).intValue();
        max = Math.abs(max);
        int number = r.nextInt(max) + 1;
        long product = (long)number * spaces;
        String key = Long.toString(product);
        int numChars = r.nextInt(12) + 1;
        for (i = 0; i < numChars; ++i) {
            position = r.nextInt(key.length());
            position = Math.abs(position);
            char randChar = (char)(r.nextInt(95) + 33);
            if (randChar >= '0' && randChar <= '9') {
                randChar = (char)(randChar - 15);
            }
            key = new StringBuilder(key).insert(position, randChar).toString();
        }
        i = 0;
        while ((long)i < spaces) {
            position = r.nextInt(key.length() - 1) + 1;
            position = Math.abs(position);
            key = new StringBuilder(key).insert(position, " ").toString();
            ++i;
        }
        return key;
    }

    private static byte[] getPart(String key) throws InvalidHandshakeException {
        try {
            long keyNumber = Long.parseLong(key.replaceAll("[^0-9]", ""));
            long keySpace = key.split(" ").length - 1;
            if (keySpace == 0L) {
                throw new InvalidHandshakeException("invalid Sec-WebSocket-Key (/key2/)");
            }
            long part = new Long(keyNumber / keySpace);
            return new byte[]{(byte)(part >> 24), (byte)(part << 8 >> 24), (byte)(part << 16 >> 24), (byte)(part << 24 >> 24)};
        }
        catch (NumberFormatException e) {
            throw new InvalidHandshakeException("invalid Sec-WebSocket-Key (/key1/ or /key2/)");
        }
    }

    public Draft.HandshakeState acceptHandshakeAsClient(Handshakedata request, Handshakedata response) {
        if (this.failed) {
            return Draft.HandshakeState.NOT_MATCHED;
        }
        try {
            if (!response.getFieldValue("Sec-WebSocket-Origin").equals(request.getFieldValue("Origin")) || !this.basicAccept(response)) {
                return Draft.HandshakeState.NOT_MATCHED;
            }
            byte[] content = response.getContent();
            if (content == null || content.length == 0) {
                this.builder = new HandshakedataImpl1(response);
                return Draft.HandshakeState.MATCHING;
            }
            if (Arrays.equals(content, Draft_76.createChallenge(request.getFieldValue("Sec-WebSocket-Key1"), request.getFieldValue("Sec-WebSocket-Key2"), request.getContent()))) {
                return Draft.HandshakeState.MATCHED;
            }
            return Draft.HandshakeState.NOT_MATCHED;
        }
        catch (InvalidHandshakeException e) {
            throw new RuntimeException("bad handshakerequest", e);
        }
    }

    public Draft.HandshakeState acceptHandshakeAsServer(Handshakedata handshakedata) {
        if (handshakedata.getFieldValue("Upgrade").equals("WebSocket") && handshakedata.getFieldValue("Connection").contains("Upgrade") && !handshakedata.getFieldValue("Sec-WebSocket-Key1").isEmpty() && !handshakedata.getFieldValue("Sec-WebSocket-Key2").isEmpty() && handshakedata.hasFieldValue("Origin")) {
            return Draft.HandshakeState.MATCHED;
        }
        return Draft.HandshakeState.NOT_MATCHED;
    }

    public HandshakeBuilder postProcessHandshakeRequestAsClient(HandshakeBuilder request) {
        request.put("Upgrade", "WebSocket");
        request.put("Connection", "Upgrade");
        request.put("Sec-WebSocket-Key1", this.generateKey());
        request.put("Sec-WebSocket-Key2", this.generateKey());
        byte[] key3 = new byte[8];
        new Random().nextBytes(key3);
        request.setContent(key3);
        return request;
    }

    public HandshakeBuilder postProcessHandshakeResponseAsServer(Handshakedata request, HandshakeBuilder response) throws InvalidHandshakeException {
        response.put("Upgrade", "WebSocket");
        response.put("Connection", request.getFieldValue("Connection"));
        response.put("Sec-WebSocket-Origin", request.getFieldValue("Origin"));
        String location = "ws://" + request.getFieldValue("Host") + request.getResourceDescriptor();
        response.put("Sec-WebSocket-Location", location);
        String key1 = request.getFieldValue("Sec-WebSocket-Key1");
        String key2 = request.getFieldValue("Sec-WebSocket-Key2");
        byte[] key3 = request.getContent();
        if (key1 == null || key2 == null || key3 == null || key3.length != 8) {
            throw new InvalidHandshakeException("Bad keys");
        }
        response.setContent(Draft_76.createChallenge(key1, key2, key3));
        return response;
    }

    public Handshakedata translateHandshake(byte[] buffer, int readcount) throws InvalidHandshakeException {
        if (this.builder != null) {
            if (readcount == 16) {
                ByteBuffer buf = ByteBuffer.allocate(readcount);
                buf.put(buffer, 0, readcount);
                this.builder.setContent(buf.array());
                return this.builder;
            }
            this.failed = true;
        }
        return super.translateHandshake(buffer, readcount);
    }
}

