/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.websocket.drafts;

import com.netiq.websocket.Base64;
import com.netiq.websocket.Draft;
import com.netiq.websocket.Framedata;
import com.netiq.websocket.FramedataImpl1;
import com.netiq.websocket.HandshakeBuilder;
import com.netiq.websocket.Handshakedata;
import com.netiq.websocket.WebSocket;
import com.netiq.websocket.exceptions.InvalidHandshakeException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Draft_10
extends Draft {
    private ByteBuffer incompleteframe;

    public static int readVersion(Handshakedata handshakedata) {
        String vers = handshakedata.getFieldValue("Sec-WebSocket-Version");
        if (vers.length() > 0) {
            try {
                int v = new Integer(vers.trim());
                return v;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public Draft.HandshakeState acceptHandshakeAsClient(Handshakedata request, Handshakedata response) throws InvalidHandshakeException {
        if (!request.hasFieldValue("Sec-WebSocket-Key") || !response.hasFieldValue("Sec-WebSocket-Accept")) {
            return Draft.HandshakeState.NOT_MATCHED;
        }
        String seckey_answere = response.getFieldValue("Sec-WebSocket-Accept");
        String seckey_challenge = request.getFieldValue("Sec-WebSocket-Key");
        if ((seckey_challenge = this.generateFinalKey(seckey_challenge)).equals(seckey_answere)) {
            return Draft.HandshakeState.MATCHED;
        }
        return Draft.HandshakeState.NOT_MATCHED;
    }

    @Override
    public Draft.HandshakeState acceptHandshakeAsServer(Handshakedata handshakedata) throws InvalidHandshakeException {
        int v = Draft_10.readVersion(handshakedata);
        if (v == 7 || v == 8) {
            return this.basicAccept(handshakedata) ? Draft.HandshakeState.MATCHED : Draft.HandshakeState.NOT_MATCHED;
        }
        return Draft.HandshakeState.NOT_MATCHED;
    }

    @Override
    public ByteBuffer createBinaryFrame(Framedata framedata) {
        byte[] mes = framedata.getPayloadData();
        boolean mask = framedata.getTransfereMasked();
        int sizebytes = mes.length == 0 ? 0 : (mes.length <= 125 ? 1 : (mes.length <= 65535 ? 2 : 8));
        ByteBuffer buf = ByteBuffer.allocate(1 + (sizebytes > 1 ? sizebytes + 1 : sizebytes) + (mask ? 4 : 0) + mes.length);
        byte optcode = this.fromOpcode(framedata.getOpcode());
        byte one = (byte)(framedata.isFin() ? -128 : 0);
        one = (byte)(one | optcode);
        buf.put(one);
        byte[] payloadlengthbytes = this.toByteArray(mes.length, sizebytes);
        assert (payloadlengthbytes.length == sizebytes);
        if (sizebytes != 0) {
            if (sizebytes == 1) {
                buf.put((byte)(payloadlengthbytes[0] | (mask ? -128 : 0)));
            } else if (sizebytes == 2) {
                buf.put((byte)(0x7E | (mask ? -128 : 0)));
                buf.put(payloadlengthbytes);
            } else if (sizebytes == 8) {
                buf.put((byte)(0x7F | (mask ? -128 : 0)));
                buf.put(payloadlengthbytes);
            } else {
                throw new RuntimeException("Size representation not supported/specified");
            }
        }
        if (mask) {
            ByteBuffer maskkey = ByteBuffer.allocate(4);
            maskkey.putInt(new Random().nextInt());
            buf.put(maskkey.array());
            for (int i = 0; i < mes.length; ++i) {
                buf.put((byte)(mes[i] ^ maskkey.get(i % 4)));
            }
        } else {
            buf.put(mes);
        }
        assert (buf.remaining() == 0) : buf.remaining();
        buf.flip();
        return buf;
    }

    @Override
    public List<Framedata> createFrames(byte[] binary, boolean mask) {
        throw new RuntimeException("not yet implemented");
    }

    @Override
    public List<Framedata> createFrames(String text, boolean mask) {
        FramedataImpl1 curframe = new FramedataImpl1();
        byte[] pay = WebSocket.utf8Bytes(text);
        curframe.setPayload(pay);
        curframe.setFin(true);
        curframe.setOptcode(Framedata.Opcode.TEXT);
        curframe.setTransferemasked(mask);
        return Collections.singletonList(curframe);
    }

    private byte fromOpcode(Framedata.Opcode opcode) {
        if (opcode == Framedata.Opcode.CONTINIOUS) {
            return 0;
        }
        if (opcode == Framedata.Opcode.TEXT) {
            return 1;
        }
        if (opcode == Framedata.Opcode.BINARY) {
            return 2;
        }
        if (opcode == Framedata.Opcode.CLOSING) {
            return 8;
        }
        if (opcode == Framedata.Opcode.PING) {
            return 9;
        }
        if (opcode == Framedata.Opcode.PONG) {
            return 10;
        }
        throw new RuntimeException("Don't know how to handle " + opcode.toString());
    }

    private String generateFinalKey(String in) {
        MessageDigest sh1;
        String seckey = in.trim();
        String acc = seckey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        try {
            sh1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return Base64.encodeBytes(sh1.digest(acc.getBytes()));
    }

    @Override
    public HandshakeBuilder postProcessHandshakeRequestAsClient(HandshakeBuilder request) {
        request.put("Upgrade", "websocket");
        request.put("Connection", "Upgrade");
        request.put("Sec-WebSocket-Version", "8");
        byte[] random = new byte[16];
        new Random().nextBytes(random);
        request.put("Sec-WebSocket-Key", Base64.encodeBytes(random));
        return request;
    }

    @Override
    public HandshakeBuilder postProcessHandshakeResponseAsServer(Handshakedata request, HandshakeBuilder response) throws InvalidHandshakeException {
        response.put("Upgrade", "websocket");
        response.put("Connection", request.getFieldValue("Connection"));
        response.setHttpStatusMessage("Switching Protocols");
        String seckey = request.getFieldValue("Sec-WebSocket-Key");
        if (seckey == null) {
            throw new InvalidHandshakeException("missing Sec-WebSocket-Key");
        }
        response.put("Sec-WebSocket-Accept", this.generateFinalKey(seckey));
        return response;
    }

    private byte[] toByteArray(long val, int bytecount) {
        byte[] buffer = new byte[bytecount];
        int highest = 8 * bytecount - 8;
        for (int i = 0; i < bytecount; ++i) {
            buffer[i] = (byte)(val >>> highest - 8 * i);
        }
        return buffer;
    }

    private Framedata.Opcode toOpcode(byte opcode) {
        switch (opcode) {
            case 0: {
                return Framedata.Opcode.CONTINIOUS;
            }
            case 1: {
                return Framedata.Opcode.TEXT;
            }
            case 2: {
                return Framedata.Opcode.BINARY;
            }
            case 8: {
                return Framedata.Opcode.CLOSING;
            }
            case 9: {
                return Framedata.Opcode.PING;
            }
            case 10: {
                return Framedata.Opcode.PONG;
            }
        }
        return null;
    }

    @Override
    public List<Framedata> translateFrame(ByteBuffer buffer, int available) {
        Framedata cur;
        LinkedList<Framedata> frames = new LinkedList<Framedata>();
        int offset = 0;
        if (this.incompleteframe != null) {
            while (true) {
                try {
                    int available_next_byte_count = available;
                    int expected_next_byte_count = this.incompleteframe.remaining();
                    if (expected_next_byte_count > available_next_byte_count) {
                        this.incompleteframe.put(buffer.array(), 0, available_next_byte_count);
                        return frames;
                    }
                    this.incompleteframe.put(buffer.array(), 0, expected_next_byte_count);
                    cur = this.translateSingleFrame(this.incompleteframe, 0, this.incompleteframe.limit());
                    frames.add(cur);
                    offset = expected_next_byte_count;
                    this.incompleteframe = null;
                }
                catch (IncompleteException e) {
                    ByteBuffer extendedframe = ByteBuffer.allocate(e.getPreferedSize());
                    assert (extendedframe.limit() > this.incompleteframe.limit());
                    extendedframe.put(this.incompleteframe.array());
                    this.incompleteframe = extendedframe;
                    continue;
                }
                break;
            }
        }
        while (offset < available) {
            try {
                cur = this.translateSingleFrame(buffer, offset, available);
                offset = buffer.position();
                frames.add(cur);
            }
            catch (IncompleteException e) {
                int pref = e.getPreferedSize();
                this.incompleteframe = ByteBuffer.allocate(pref);
                this.incompleteframe.put(buffer.array(), offset, available - offset);
                break;
            }
        }
        return frames;
    }

    public Framedata translateSingleFrame(ByteBuffer buffer, int foff, int available) throws IncompleteException {
        int maxpacketsize = available - foff;
        int realpacketsize = 2;
        byte[] b = buffer.array();
        if (maxpacketsize < realpacketsize) {
            throw new IncompleteException(realpacketsize);
        }
        boolean FIN = b[foff + 0] >> 8 != 0;
        boolean MASK = (b[foff + 1] & 0xFFFFFF80) != 0;
        int payloadlength = b[foff + 1] & 0x7F;
        if (payloadlength > 125) {
            if (payloadlength == 126) {
                if (maxpacketsize < (realpacketsize += 2)) {
                    throw new IncompleteException(realpacketsize);
                }
                byte[] sizebytes = new byte[]{b[foff + 1 + 1], b[foff + 1 + 2]};
                payloadlength = new BigInteger(sizebytes).intValue();
            } else {
                if (maxpacketsize < (realpacketsize += 8)) {
                    throw new IncompleteException(realpacketsize);
                }
                byte[] bytes = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    bytes[i] = b[foff + 1 + i];
                }
                long length = new BigInteger(bytes).longValue();
                if (length > Integer.MAX_VALUE) {
                    throw new RuntimeException("Payloadsize is to big...");
                }
            }
        }
        int maskskeystart = foff + realpacketsize;
        int payloadstart = foff + (realpacketsize += MASK ? 4 : 0);
        if (maxpacketsize < (realpacketsize += payloadlength)) {
            throw new IncompleteException(realpacketsize);
        }
        ByteBuffer payload = ByteBuffer.allocate(payloadlength);
        if (MASK) {
            byte[] maskskey = ByteBuffer.allocate(4).put(b, maskskeystart, 4).array();
            for (int i = 0; i < payloadlength; ++i) {
                payload.put((byte)(b[payloadstart + i] ^ maskskey[i % 4]));
            }
        } else {
            payload.put(b, payloadstart, payloadlength);
        }
        buffer.position(payloadstart + payloadlength);
        FramedataImpl1 frame = new FramedataImpl1();
        frame.setFin(FIN);
        frame.setOptcode(this.toOpcode((byte)(b[foff + 0] & 0xF)));
        frame.setPayload(payload.array());
        return frame;
    }

    private class IncompleteException
    extends Throwable {
        private int preferedsize;

        public IncompleteException(int preferedsize) {
            this.preferedsize = preferedsize;
        }

        public int getPreferedSize() {
            return this.preferedsize;
        }
    }
}

