/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.websocket;

import com.netiq.websocket.Draft;
import com.netiq.websocket.WebSocket;
import com.netiq.websocket.WebSocketAdapter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebSocketServer
extends WebSocketAdapter
implements Runnable {
    protected static final String FLASH_POLICY_REQUEST = "<policy-file-request/>\u0000";
    protected final CopyOnWriteArraySet<WebSocket> connections = new CopyOnWriteArraySet();
    protected int port;
    protected ServerSocketChannel server;
    protected Selector selector;
    protected Draft draft;

    public WebSocketServer() {
        this(80, null);
    }

    public WebSocketServer(int port) {
        this(port, null);
    }

    public WebSocketServer(int port, Draft draft) {
        this.draft = draft;
        this.setPort(port);
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() throws IOException {
        for (WebSocket ws : this.connections) {
            ws.close();
        }
        this.server.close();
    }

    public void sendToAll(String text) throws IOException {
        for (WebSocket c : this.connections) {
            c.send(text);
        }
    }

    public void sendToAllExcept(WebSocket connection, String text) throws IOException {
        if (connection == null) {
            throw new NullPointerException("'connection' cannot be null");
        }
        for (WebSocket c : this.connections) {
            if (connection.equals(c)) continue;
            c.send(text);
        }
    }

    public void sendToAllExcept(Set<WebSocket> connections, String text) throws IOException {
        if (connections == null) {
            throw new NullPointerException("'connections' cannot be null");
        }
        for (WebSocket c : this.connections) {
            if (connections.contains(c)) continue;
            c.send(text);
        }
    }

    public WebSocket[] connections() {
        return this.connections.toArray(new WebSocket[0]);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public Draft getDraft() {
        return this.draft;
    }

    @Override
    public void run() {
        try {
            this.server = ServerSocketChannel.open();
            this.server.configureBlocking(false);
            this.server.socket().bind(new InetSocketAddress(this.port));
            this.selector = Selector.open();
            this.server.register(this.selector, this.server.validOps());
        }
        catch (IOException ex) {
            this.onError(ex);
            return;
        }
        block6: while (true) {
            SelectionKey key = null;
            try {
                this.selector.select();
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> i = keys.iterator();
                while (i.hasNext()) {
                    WebSocket conn;
                    key = i.next();
                    i.remove();
                    if (key.isAcceptable()) {
                        SocketChannel client = this.server.accept();
                        client.configureBlocking(false);
                        WebSocket c = new WebSocket(client, new LinkedBlockingQueue<ByteBuffer>(), this, Integer.MAX_VALUE);
                        client.register(this.selector, 1, c);
                    }
                    if (key.isReadable()) {
                        conn = (WebSocket)key.attachment();
                        conn.handleRead();
                    }
                    if (!key.isValid() || !key.isWritable() || !(conn = (WebSocket)key.attachment()).handleWrite()) continue;
                    conn.socketChannel().register(this.selector, 1, conn);
                }
                Iterator<WebSocket> i$ = this.connections.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block6;
                    WebSocket conn = i$.next();
                    if (!conn.hasBufferedData()) continue;
                    conn.socketChannel().register(this.selector, 5, conn);
                }
            }
            catch (IOException ex) {
                if (key != null) {
                    key.cancel();
                }
                this.onError(ex);
                continue;
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected String getFlashSecurityPolicy() {
        return "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"" + this.getPort() + "\" /></cross-domain-policy>";
    }

    @Override
    public void onMessage(WebSocket conn, String message) {
        this.onClientMessage(conn, message);
    }

    @Override
    public void onOpen(WebSocket conn) {
        if (this.connections.add(conn)) {
            this.onClientOpen(conn);
        }
    }

    @Override
    public void onClose(WebSocket conn) {
        if (this.connections.remove(conn)) {
            this.onClientClose(conn);
        }
    }

    protected byte[] getPart(String key) {
        long keyNumber = Long.parseLong(key.replaceAll("[^0-9]", ""));
        long keySpace = key.split(" ").length - 1;
        long part = new Long(keyNumber / keySpace);
        return new byte[]{(byte)(part >> 24), (byte)(part << 8 >> 24), (byte)(part << 16 >> 24), (byte)(part << 24 >> 24)};
    }

    public abstract void onClientOpen(WebSocket var1);

    public abstract void onClientClose(WebSocket var1);

    public abstract void onClientMessage(WebSocket var1, String var2);

    @Override
    public abstract void onError(Throwable var1);
}

