/*
 * Decompiled with CFR 0.152.
 */
package com.netiq.websocket;

import com.netiq.websocket.HandshakeBuilder;
import com.netiq.websocket.Handshakedata;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandshakedataImpl1
implements HandshakeBuilder {
    private String httpstatusmessage;
    private String resourcedescriptor;
    private byte[] content;
    private LinkedHashMap<String, String> map;

    public HandshakedataImpl1() {
        this.map = new LinkedHashMap();
    }

    public HandshakedataImpl1(Handshakedata h) {
        this.httpstatusmessage = h.getHttpStatusMessage();
        this.resourcedescriptor = h.getResourceDescriptor();
        this.content = h.getContent();
        this.map = new LinkedHashMap();
        Iterator<String> it = h.iterateHttpFields();
        while (it.hasNext()) {
            String key = it.next();
            this.map.put(key, h.getFieldValue(key));
        }
    }

    @Override
    public String getResourceDescriptor() {
        return this.resourcedescriptor == null ? "" : this.resourcedescriptor;
    }

    @Override
    public Iterator<String> iterateHttpFields() {
        return Collections.unmodifiableSet(this.map.keySet()).iterator();
    }

    @Override
    public String getFieldValue(String name) {
        String s = this.map.get(name);
        if (s == null) {
            return "";
        }
        return s;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    @Override
    public void setContent(byte[] content) {
        this.content = content;
    }

    @Override
    public void setResourceDescriptor(String resourcedescriptor) {
        this.resourcedescriptor = resourcedescriptor;
    }

    @Override
    public void put(String name, String value) {
        this.map.put(name, value);
    }

    @Override
    public boolean hasFieldValue(String name) {
        return this.map.containsKey(name);
    }

    @Override
    public String getHttpStatusMessage() {
        return this.httpstatusmessage;
    }

    @Override
    public void setHttpStatusMessage(String message) {
        this.httpstatusmessage = message;
    }
}

