/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev.rest.representations;

import com.atlassian.fastdev.maven.MavenTask;
import com.atlassian.fastdev.rest.FastdevUriBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class MavenTaskRepresentation {
    @JsonProperty
    private final Collection<String> output;
    @JsonProperty
    private final Map<String, URI> links;
    @JsonProperty
    private final String id;
    @JsonProperty
    private final Integer exitCode;
    @JsonProperty
    private final Long averageTaskTime;
    @JsonProperty
    private final Long elapsedTime;

    @JsonCreator
    public MavenTaskRepresentation(@JsonProperty(value="output") Collection<String> output, @JsonProperty(value="links") Map<String, URI> links, @JsonProperty(value="id") String id, @JsonProperty(value="exitCode") Integer exitCode, @JsonProperty(value="averageTaskTime") Long averageTaskTime, @JsonProperty(value="elapsedTime") Long elapsedTime) {
        this.output = ImmutableList.copyOf(output);
        this.links = ImmutableMap.copyOf(links);
        this.id = id;
        this.exitCode = exitCode;
        this.averageTaskTime = averageTaskTime;
        this.elapsedTime = elapsedTime;
    }

    public MavenTaskRepresentation(MavenTask task, FastdevUriBuilder uriBuilder) {
        this.output = ImmutableList.copyOf(task.getOutput());
        this.links = ImmutableMap.of((Object)"self", (Object)uriBuilder.buildMavenTaskUri(task));
        this.id = task.getUuid().toString();
        this.exitCode = task.getExitCode();
        this.averageTaskTime = task.getAverageTaskTime();
        this.elapsedTime = task.getElapsedTime();
    }
}

