/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev.maven;

import com.atlassian.fastdev.ScanResult;
import com.atlassian.fastdev.maven.CLIProcess;
import com.atlassian.fastdev.maven.MavenTask;
import com.atlassian.fastdev.maven.MavenTaskManager;
import com.atlassian.fastdev.util.AvailablePortFinder;
import com.atlassian.fastdev.util.StreamEater;
import com.atlassian.fastdev.util.StreamPromptFinder;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.lang.SystemUtils;

public class CLIMavenTask
implements MavenTask {
    public static final Integer DEFAULT_CLI_PORT = 4330;
    private static volatile Integer defaultPort = 0;
    private final MavenTaskManager mavenTaskManager;
    private final ExecutorService executorService;
    private final ScanResult scanResult;
    private final UUID uuid;
    private final ConcurrentLinkedQueue<String> output;
    private final List<String> cliArgs;
    private final String cliCommand;
    private volatile Integer exitCode;
    private final long currentAverage;
    private volatile long startTime;

    CLIMavenTask(UUID uuid, ScanResult result, List<String> cliArgs, String command, MavenTaskManager mavenTaskManager, ExecutorService executorService) {
        this.mavenTaskManager = mavenTaskManager;
        this.executorService = executorService;
        this.scanResult = result;
        this.cliArgs = cliArgs;
        this.cliCommand = command;
        this.uuid = uuid;
        this.output = new ConcurrentLinkedQueue();
        this.currentAverage = mavenTaskManager.averageBuildTime(this.scanResult.getBuildRoot());
    }

    @Override
    public File getBuildRoot() {
        return this.scanResult.getBuildRoot();
    }

    @Override
    public long getAverageTaskTime() {
        return this.currentAverage;
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Iterable<String> getOutput() {
        return ImmutableList.copyOf(this.output);
    }

    @Override
    public Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    public void setExitCode(Integer code) {
        this.exitCode = code;
    }

    @Override
    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public Future<Integer> start() {
        return this.executorService.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Integer port = 0;
                try {
                    CLIMavenTask.this.startTime = System.currentTimeMillis();
                    port = CLIMavenTask.this.startCliIfNeeded(CLIMavenTask.this.scanResult, CLIMavenTask.this.cliArgs, CLIMavenTask.this.output);
                    CLIProcess cliProcess = CLIMavenTask.this.mavenTaskManager.getCliProcess(CLIMavenTask.this.scanResult.getBuildRoot());
                    Process process = cliProcess.getProcess();
                    ((CLIMavenTask)CLIMavenTask.this).mavenTaskManager.LOG.info("sending command to CLI: " + CLIMavenTask.this.cliCommand);
                    int cliSuccess = 0;
                    if (SystemUtils.IS_OS_WINDOWS) {
                        StreamEater eater = new StreamEater(process.getInputStream(), CLIMavenTask.this.output);
                        cliSuccess = CLIMavenTask.this.execWithSocket(port);
                        eater.kill();
                    } else {
                        cliSuccess = CLIMavenTask.this.execWithProcess(process);
                    }
                    CLIMavenTask.this.exitCode = cliSuccess;
                    CLIMavenTask.this.mavenTaskManager.recordBuildTime(CLIMavenTask.this.scanResult.getBuildRoot(), System.currentTimeMillis() - CLIMavenTask.this.startTime);
                    CLIMavenTask.this.mavenTaskManager.remove(CLIMavenTask.this);
                    return CLIMavenTask.this.exitCode;
                }
                catch (IOException e) {
                    ((CLIMavenTask)CLIMavenTask.this).mavenTaskManager.LOG.error("Unable to send data to port", (Throwable)e);
                    throw new Exception("Cannot connect to the cli port '" + port + "'.");
                }
            }
        });
    }

    private int execWithSocket(Integer port) throws Exception {
        this.mavenTaskManager.LOG.debug("Connecting to socket on port: " + port);
        Socket socket = new Socket("localhost", (int)port);
        OutputStream out = socket.getOutputStream();
        InputStream is = socket.getInputStream();
        this.mavenTaskManager.LOG.debug("starting stream eater");
        StreamPromptFinder finder = new StreamPromptFinder(is, this.output, this.mavenTaskManager.LOG);
        this.mavenTaskManager.LOG.debug("writing command to socket: " + this.cliCommand);
        out.write((this.cliCommand + "\n").getBytes());
        out.flush();
        this.mavenTaskManager.LOG.debug("looking for maven cli prompt from socket...");
        finder.join();
        socket.close();
        is = null;
        out = null;
        socket = null;
        this.exitCode = this.outputContainsError();
        this.mavenTaskManager.LOG.debug("returning exit code");
        return this.exitCode;
    }

    private Integer outputContainsError() {
        int success = 0;
        for (String line : this.output) {
            if (!line.contains("ERROR]")) continue;
            success = 1;
            break;
        }
        if (success < 1) {
            this.output.add("BUILD SUCCESSFUL\n");
        } else {
            this.output.add("BUILD ERROR");
        }
        return success;
    }

    private int execWithProcess(Process process) throws Exception {
        OutputStream out = process.getOutputStream();
        out.write((this.cliCommand + "\n").getBytes());
        out.flush();
        InputStreamReader isr = new InputStreamReader(process.getInputStream());
        BufferedReader br = new BufferedReader(isr);
        return this.readUntilMavenCliPrompt(br, this.output);
    }

    private Integer pickFreeCliPort(Integer oldPort) throws Exception {
        Integer newDefaultPort;
        defaultPort = defaultPort < 1 ? DEFAULT_CLI_PORT : Integer.valueOf(defaultPort + 1);
        defaultPort = newDefaultPort = Integer.valueOf(this.mavenTaskManager.cliPortTaken(defaultPort) ? defaultPort + 1 : defaultPort);
        if (oldPort > 0) {
            return AvailablePortFinder.getPortOrNextAvailable(oldPort, newDefaultPort);
        }
        return AvailablePortFinder.getPortOrNextAvailable(newDefaultPort, newDefaultPort);
    }

    private synchronized Integer startCliIfNeeded(ScanResult result, List<String> cliArgs, ConcurrentLinkedQueue<String> output) throws Exception {
        Integer port = 0;
        if (!this.mavenTaskManager.hasCliProcess(result.getBuildRoot()) || result.isPomChanged()) {
            CLIProcess cliProcess = this.mavenTaskManager.getCliProcess(result.getBuildRoot());
            Integer oldPort = 0;
            if (null != cliProcess) {
                oldPort = cliProcess.getPort();
                this.mavenTaskManager.removeCliProcess(result.getBuildRoot(), cliProcess);
                cliProcess.getProcess().destroy();
            }
            Integer newPort = this.pickFreeCliPort(oldPort);
            ImmutableList.Builder commandsBuilder = ImmutableList.builder();
            if (SystemUtils.IS_OS_WINDOWS) {
                commandsBuilder.add((Object[])new String[]{"cmd", "/c"});
            }
            commandsBuilder.add((Object)this.mavenTaskManager.getMavenCommand());
            commandsBuilder.addAll(cliArgs);
            commandsBuilder.add((Object)("-Dcli.port=" + newPort));
            ImmutableList commands = commandsBuilder.build();
            ProcessBuilder processBuilder = new ProcessBuilder((List<String>)commands);
            processBuilder.directory(result.getBuildRoot());
            processBuilder.environment().remove("MAVEN_COLOR");
            Process process = processBuilder.start();
            this.mavenTaskManager.addCliProcess(result.getBuildRoot(), new CLIProcess(newPort, process));
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            this.readUntilMavenCliPrompt(br, output);
            this.mavenTaskManager.LOG.info("Maven CLI started on port: " + newPort);
            port = newPort;
        } else {
            port = this.mavenTaskManager.getCliProcess(result.getBuildRoot()).getPort();
        }
        return port;
    }

    private int readUntilMavenCliPrompt(BufferedReader br, ConcurrentLinkedQueue<String> output) throws Exception {
        this.mavenTaskManager.LOG.debug("reading until prompt is found...");
        int exit = this.readUntilStringFound("maven>", br, output);
        if (exit < 1) {
            output.add("BUILD SUCCESSFUL\n");
        } else {
            output.add("BUILD ERROR");
        }
        this.mavenTaskManager.LOG.info("Got CLI prompt");
        return exit;
    }

    private int readUntilStringFound(String token, BufferedReader br, ConcurrentLinkedQueue<String> output) throws Exception {
        int c;
        int exit = 0;
        char[] endMarker = token.toCharArray();
        char[] endBuffer = new char[endMarker.length];
        int bufLen = 0;
        int markerEndIndex = endMarker.length - 1;
        boolean foundMarker = false;
        StringBuffer lineBuffer = new StringBuffer();
        while ((c = br.read()) > -1) {
            this.mavenTaskManager.LOG.debug("cli char: " + (char)c);
            System.out.print((char)c);
            lineBuffer.append((char)c);
            if (c == 10 || c == 13) {
                String line = lineBuffer.toString();
                if (line.contains("ERROR]")) {
                    exit = 1;
                }
                output.add(line);
                this.mavenTaskManager.LOG.debug("cli: " + line);
                lineBuffer = new StringBuffer();
            }
            if (!foundMarker && c == endMarker[bufLen]) {
                endBuffer[bufLen] = (char)c;
                if (bufLen == markerEndIndex) {
                    String line2 = lineBuffer.toString();
                    foundMarker = true;
                    output.add(line2);
                    this.mavenTaskManager.LOG.debug("cli: " + line2);
                    break;
                }
                ++bufLen;
                continue;
            }
            bufLen = 0;
        }
        if (!foundMarker) {
            throw new Exception("unable to get maven> prompt");
        }
        return exit;
    }
}

