/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.json.marshal.wrapped;

import com.atlassian.json.marshal.wrapped.WrappingJsonable;

public class JsonableString
extends WrappingJsonable<String> {
    public JsonableString(String value) {
        super(value);
    }

    @Override
    protected String convertValueToString(String value) {
        return JsonableString.jsonEscape(value);
    }

    static String jsonEscape(String input) {
        if (input == null) {
            return "\"null\"";
        }
        StringBuilder sb = new StringBuilder((int)((double)input.length() * 1.1));
        sb.append("\"");
        block8: for (char c : input.toCharArray()) {
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f') {
                        JsonableString.appendHex(c, sb);
                        continue block8;
                    }
                    if (c >= '\u007f' && c <= '\u009f') {
                        JsonableString.appendHex(c, sb);
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    private static void appendHex(char c, StringBuilder sb) {
        sb.append("\\u");
        String hex = Integer.toHexString(c).toUpperCase();
        switch (hex.length()) {
            case 1: {
                sb.append("000").append(hex);
                return;
            }
            case 2: {
                sb.append("00").append(hex);
                return;
            }
            case 3: {
                sb.append("0").append(hex);
                return;
            }
            case 4: {
                sb.append(hex);
                return;
            }
        }
        throw new IllegalStateException("Could not calculate unicode for character: " + hex);
    }
}

