/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.ServerInfo;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class ServerInfoJsonParser
implements JsonParser<ServerInfo> {
    @Override
    public ServerInfo parse(JSONObject json) throws JSONException {
        URI baseUri = JsonParseUtil.parseURI(json.getString("baseUrl"));
        String version = json.getString("version");
        int buildNumber = json.getInt("buildNumber");
        DateTime buildDate = JsonParseUtil.parseDateTime(json, "buildDate");
        DateTime serverTime = JsonParseUtil.parseOptionalDateTime(json, "serverTime");
        String scmInfo = json.getString("scmInfo");
        String serverTitle = json.getString("serverTitle");
        return new ServerInfo(baseUri, version, buildNumber, buildDate, serverTime, scmInfo, serverTitle);
    }
}

