/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CommentJsonParser
implements JsonParser<Comment> {
    @Override
    public Comment parse(JSONObject json) throws JSONException {
        URI selfUri = JsonParseUtil.getSelfUri(json);
        String body = json.getString("body");
        BasicUser author = JsonParseUtil.parseBasicUser(json.getJSONObject("author"));
        BasicUser updateAuthor = JsonParseUtil.parseBasicUser(json.getJSONObject("updateAuthor"));
        String roleLevel = json.optString("roleLevel", null);
        String groupLevel = json.optString("groupLevel", null);
        return new Comment(selfUri, body, author, updateAuthor, JsonParseUtil.parseDateTime(json.getString("created")), JsonParseUtil.parseDateTime(json.getString("updated")), roleLevel, groupLevel);
    }
}

