/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.jersey;

import com.atlassian.jira.rest.client.ProgressMonitor;
import com.atlassian.jira.rest.client.ProjectRestClient;
import com.atlassian.jira.rest.client.domain.Project;
import com.atlassian.jira.rest.client.internal.jersey.AbstractJerseyRestClient;
import com.atlassian.jira.rest.client.internal.json.ProjectJsonParser;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.client.apache.ApacheHttpClient;
import java.net.URI;
import java.util.concurrent.Callable;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jettison.json.JSONObject;

public class JerseyProjectRestClient
extends AbstractJerseyRestClient
implements ProjectRestClient {
    private static final String PROJECT_URI_PREFIX = "project";
    private final ProjectJsonParser projectJsonParser = new ProjectJsonParser();

    public JerseyProjectRestClient(URI baseUri, ApacheHttpClient client) {
        super(baseUri, client);
    }

    @Override
    public Project getProject(final URI projectUri, ProgressMonitor progressMonitor) {
        return this.invoke(new Callable<Project>(){

            @Override
            public Project call() throws Exception {
                WebResource projectResource = JerseyProjectRestClient.this.client.resource(projectUri);
                JSONObject jsonObject = (JSONObject)projectResource.get(JSONObject.class);
                return JerseyProjectRestClient.this.projectJsonParser.parse(jsonObject);
            }
        });
    }

    @Override
    public Project getProject(String key, ProgressMonitor progressMonitor) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path(PROJECT_URI_PREFIX).path(key).build(new Object[0]);
        return this.getProject(uri, progressMonitor);
    }
}

