/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.domain;

import com.atlassian.jira.rest.client.AddressableEntity;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.google.common.base.Objects;
import java.net.URI;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class Comment
implements AddressableEntity {
    private final URI self;
    private final BasicUser author;
    private final BasicUser updateAuthor;
    private final DateTime creationDate;
    private final DateTime updateDate;
    private final String body;
    private final String roleLevel;
    private final String groupLevel;

    public Comment(URI self, String body, BasicUser author, BasicUser updateAuthor, DateTime creationDate, DateTime updateDate, String roleLevel, String groupLevel) {
        if (roleLevel != null && groupLevel != null) {
            throw new IllegalArgumentException("Role and group visibility cannot be set at the same time");
        }
        this.author = author;
        this.updateAuthor = updateAuthor;
        this.creationDate = creationDate;
        this.updateDate = updateDate;
        this.body = body;
        this.self = self;
        this.roleLevel = roleLevel;
        this.groupLevel = groupLevel;
    }

    public static Comment valueOf(String body) {
        return new Comment(null, body, null, null, null, null, null, null);
    }

    public static Comment createWithRoleLevel(String body, String roleLevel) {
        return new Comment(null, body, null, null, null, null, roleLevel, null);
    }

    public static Comment createWithGroupLevel(String body, String groupLevel) {
        return new Comment(null, body, null, null, null, null, null, groupLevel);
    }

    public boolean wasUpdated() {
        return this.updateDate.isAfter((ReadableInstant)this.creationDate);
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public URI getSelf() {
        return this.self;
    }

    public BasicUser getAuthor() {
        return this.author;
    }

    public BasicUser getUpdateAuthor() {
        return this.updateAuthor;
    }

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public DateTime getUpdateDate() {
        return this.updateDate;
    }

    @Nullable
    public String getRoleLevel() {
        return this.roleLevel;
    }

    @Nullable
    public String getGroupLevel() {
        return this.groupLevel;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("self", (Object)this.self).add("body", (Object)this.body).add("author", (Object)this.author).add("updateAuthor", (Object)this.updateAuthor).add("creationDate", (Object)this.creationDate).add("roleLevel", (Object)this.roleLevel).add("groupLevel", (Object)this.groupLevel).add("updateDate", (Object)this.updateDate).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Comment) {
            Comment that = (Comment)obj;
            return Objects.equal((Object)this.self, (Object)that.self) && Objects.equal((Object)this.body, (Object)that.body) && Objects.equal((Object)this.author, (Object)that.author) && Objects.equal((Object)this.updateAuthor, (Object)that.updateAuthor) && Objects.equal((Object)this.creationDate, (Object)that.creationDate) && Objects.equal((Object)this.updateDate, (Object)that.updateDate) && Objects.equal((Object)this.roleLevel, (Object)that.roleLevel) && Objects.equal((Object)this.groupLevel, (Object)that.groupLevel) && Objects.equal((Object)this.body, (Object)that.body);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.self, this.body, this.author, this.updateAuthor, this.creationDate, this.updateDate, this.roleLevel, this.groupLevel});
    }
}

