/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json.gen;

import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.ServerInfo;
import com.atlassian.jira.rest.client.domain.Visibility;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CommentJsonGenerator
implements JsonGenerator<Comment> {
    private final ServerInfo serverInfo;

    public CommentJsonGenerator(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    @Override
    public JSONObject generate(Comment comment) throws JSONException {
        Visibility commentVisibility;
        JSONObject res = new JSONObject();
        if (comment.getBody() != null) {
            res.put("body", (Object)comment.getBody());
        }
        if ((commentVisibility = comment.getVisibility()) != null) {
            int buildNumber = this.serverInfo.getBuildNumber();
            if (buildNumber >= 600) {
                JSONObject visibilityJson = new JSONObject();
                String commentVisibilityType = buildNumber >= 700 ? (commentVisibility.getType() == Visibility.Type.GROUP ? "group" : "role") : (commentVisibility.getType() == Visibility.Type.GROUP ? "GROUP" : "ROLE");
                visibilityJson.put("type", (Object)commentVisibilityType);
                visibilityJson.put("value", (Object)commentVisibility.getValue());
                res.put("visibility", (Object)visibilityJson);
            } else if (commentVisibility.getType() == Visibility.Type.ROLE) {
                res.put("role", (Object)commentVisibility.getValue());
            } else {
                res.put("group", (Object)commentVisibility.getValue());
            }
        }
        return res;
    }
}

