/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.apache.httpcomponents.MultiPartEntityBuilder;
import com.atlassian.httpclient.api.EntityBuilder;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.jira.rest.client.GetCreateIssueMetadataOptions;
import com.atlassian.jira.rest.client.IssueRestClient;
import com.atlassian.jira.rest.client.MetadataRestClient;
import com.atlassian.jira.rest.client.RestClientException;
import com.atlassian.jira.rest.client.SessionRestClient;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.CimProject;
import com.atlassian.jira.rest.client.domain.Comment;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.ServerInfo;
import com.atlassian.jira.rest.client.domain.Session;
import com.atlassian.jira.rest.client.domain.Transition;
import com.atlassian.jira.rest.client.domain.Votes;
import com.atlassian.jira.rest.client.domain.Watchers;
import com.atlassian.jira.rest.client.domain.input.AttachmentInput;
import com.atlassian.jira.rest.client.domain.input.FieldInput;
import com.atlassian.jira.rest.client.domain.input.IssueInput;
import com.atlassian.jira.rest.client.domain.input.LinkIssuesInput;
import com.atlassian.jira.rest.client.domain.input.TransitionInput;
import com.atlassian.jira.rest.client.domain.input.WorklogInput;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.BasicIssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.CreateIssueMetadataJsonParser;
import com.atlassian.jira.rest.client.internal.json.IssueJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParser;
import com.atlassian.jira.rest.client.internal.json.TransitionJsonParserV5;
import com.atlassian.jira.rest.client.internal.json.VotesJsonParser;
import com.atlassian.jira.rest.client.internal.json.WatchersJsonParserBuilder;
import com.atlassian.jira.rest.client.internal.json.gen.CommentJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.IssueInputJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.IssueUpdateJsonGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.LinkIssuesInputGenerator;
import com.atlassian.jira.rest.client.internal.json.gen.WorklogInputJsonGenerator;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class AsynchronousIssueRestClient
extends AbstractAsynchronousRestClient
implements IssueRestClient {
    private static final EnumSet<IssueRestClient.Expandos> DEFAULT_EXPANDS = EnumSet.of(IssueRestClient.Expandos.NAMES, IssueRestClient.Expandos.SCHEMA, IssueRestClient.Expandos.TRANSITIONS);
    private static final Function<IssueRestClient.Expandos, String> EXPANDO_TO_PARAM = new Function<IssueRestClient.Expandos, String>(){

        public String apply(IssueRestClient.Expandos from) {
            return from.name().toLowerCase();
        }
    };
    private final SessionRestClient sessionRestClient;
    private final MetadataRestClient metadataRestClient;
    private final IssueJsonParser issueParser = new IssueJsonParser();
    private final BasicIssueJsonParser basicIssueParser = new BasicIssueJsonParser();
    private final JsonObjectParser<Watchers> watchersParser = WatchersJsonParserBuilder.createWatchersParser();
    private final TransitionJsonParser transitionJsonParser = new TransitionJsonParser();
    private final JsonObjectParser<Transition> transitionJsonParserV5 = new TransitionJsonParserV5();
    private final VotesJsonParser votesJsonParser = new VotesJsonParser();
    private final CreateIssueMetadataJsonParser createIssueMetadataJsonParser = new CreateIssueMetadataJsonParser();
    private final URI baseUri;
    private ServerInfo serverInfo;

    public AsynchronousIssueRestClient(URI baseUri, HttpClient client, SessionRestClient sessionRestClient, MetadataRestClient metadataRestClient) {
        super(client);
        this.baseUri = baseUri;
        this.sessionRestClient = sessionRestClient;
        this.metadataRestClient = metadataRestClient;
    }

    private synchronized ServerInfo getVersionInfo() {
        if (this.serverInfo == null) {
            this.serverInfo = (ServerInfo)this.metadataRestClient.getServerInfo().claim();
        }
        return this.serverInfo;
    }

    @Override
    public Promise<BasicIssue> createIssue(IssueInput issue) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path("issue");
        return this.postAndParse(uriBuilder.build(new Object[0]), issue, new IssueInputJsonGenerator(), this.basicIssueParser);
    }

    @Override
    public Promise<Iterable<CimProject>> getCreateIssueMetadata(@Nullable GetCreateIssueMetadataOptions options) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri).path("issue/createmeta");
        if (options != null) {
            Iterable<String> expandos;
            Iterable<String> issueTypeNames;
            if (options.projectIds != null) {
                uriBuilder.queryParam("projectIds", new Object[]{Joiner.on((String)",").join(options.projectIds)});
            }
            if (options.projectKeys != null) {
                uriBuilder.queryParam("projectKeys", new Object[]{Joiner.on((String)",").join(options.projectKeys)});
            }
            if (options.issueTypeIds != null) {
                uriBuilder.queryParam("issuetypeIds", new Object[]{Joiner.on((String)",").join(options.issueTypeIds)});
            }
            if ((issueTypeNames = options.issueTypeNames) != null) {
                for (String name : issueTypeNames) {
                    uriBuilder.queryParam("issuetypeNames", new Object[]{name});
                }
            }
            if ((expandos = options.expandos) != null && expandos.iterator().hasNext()) {
                uriBuilder.queryParam("expand", new Object[]{Joiner.on((String)",").join(expandos)});
            }
        }
        return this.getAndParse(uriBuilder.build(new Object[0]), this.createIssueMetadataJsonParser);
    }

    @Override
    public Promise<Issue> getIssue(String issueKey) {
        return this.getIssue(issueKey, Collections.<IssueRestClient.Expandos>emptyList());
    }

    @Override
    public Promise<Issue> getIssue(String issueKey, Iterable<IssueRestClient.Expandos> expand) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseUri);
        Iterable expands = Iterables.concat(DEFAULT_EXPANDS, expand);
        uriBuilder.path("issue").path(issueKey).queryParam("expand", new Object[]{Joiner.on((char)',').join(Iterables.transform((Iterable)expands, EXPANDO_TO_PARAM))});
        return this.getAndParse(uriBuilder.build(new Object[0]), this.issueParser);
    }

    @Override
    public Promise<Watchers> getWatchers(URI watchersUri) {
        return this.getAndParse(watchersUri, this.watchersParser);
    }

    @Override
    public Promise<Votes> getVotes(URI votesUri) {
        return this.getAndParse(votesUri, this.votesJsonParser);
    }

    @Override
    public Promise<Iterable<Transition>> getTransitions(URI transitionsUri) {
        return this.callAndParse(this.client().newRequest(transitionsUri).get(), new AbstractAsynchronousRestClient.ResponseHandler<Iterable<Transition>>(){

            @Override
            public Iterable<Transition> handle(Response response) throws JSONException, IOException {
                JSONObject jsonObject = new JSONObject(response.getEntity());
                if (jsonObject.has("transitions")) {
                    return JsonParseUtil.parseJsonArray(jsonObject.getJSONArray("transitions"), AsynchronousIssueRestClient.this.transitionJsonParserV5);
                }
                ArrayList<Transition> transitions = new ArrayList<Transition>(jsonObject.length());
                Iterator iterator = jsonObject.keys();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    try {
                        int id = Integer.parseInt(key);
                        Transition transition = AsynchronousIssueRestClient.this.transitionJsonParser.parse(jsonObject.getJSONObject(key), id);
                        transitions.add(transition);
                    }
                    catch (JSONException e) {
                        throw new RestClientException(e);
                    }
                    catch (NumberFormatException e) {
                        throw new RestClientException("Transition id should be an integer, but found [" + key + "]", e);
                    }
                }
                return transitions;
            }
        });
    }

    @Override
    public Promise<Iterable<Transition>> getTransitions(Issue issue) {
        if (issue.getTransitionsUri() != null) {
            return this.getTransitions(issue.getTransitionsUri());
        }
        UriBuilder transitionsUri = UriBuilder.fromUri((URI)issue.getSelf());
        return this.getTransitions(transitionsUri.path("transitions").queryParam("expand", new Object[]{"transitions.fields"}).build(new Object[0]));
    }

    @Override
    public Promise<Void> transition(URI transitionsUri, TransitionInput transitionInput) {
        int buildNumber = this.getVersionInfo().getBuildNumber();
        try {
            Iterable<FieldInput> fields;
            JSONObject fieldsJs;
            JSONObject jsonObject = new JSONObject();
            if (buildNumber >= 700) {
                jsonObject.put("transition", (Object)new JSONObject().put("id", transitionInput.getId()));
            } else {
                jsonObject.put("transition", transitionInput.getId());
            }
            if (transitionInput.getComment() != null) {
                if (buildNumber >= 700) {
                    jsonObject.put("update", (Object)new JSONObject().put("comment", (Object)new JSONArray().put((Object)new JSONObject().put("add", (Object)new CommentJsonGenerator(this.getVersionInfo()).generate(transitionInput.getComment())))));
                } else {
                    jsonObject.put("comment", (Object)new CommentJsonGenerator(this.getVersionInfo()).generate(transitionInput.getComment()));
                }
            }
            if ((fieldsJs = new IssueUpdateJsonGenerator().generate(fields = transitionInput.getFields())).keys().hasNext()) {
                jsonObject.put("fields", (Object)fieldsJs);
            }
            if (fieldsJs.keys().hasNext()) {
                jsonObject.put("fields", (Object)fieldsJs);
            }
            return this.post(transitionsUri, jsonObject);
        }
        catch (JSONException ex) {
            throw new RestClientException(ex);
        }
    }

    @Override
    public Promise<Void> transition(Issue issue, TransitionInput transitionInput) {
        if (issue.getTransitionsUri() != null) {
            return this.transition(issue.getTransitionsUri(), transitionInput);
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)issue.getSelf());
        uriBuilder.path("transitions");
        return this.transition(uriBuilder.build(new Object[0]), transitionInput);
    }

    @Override
    public Promise<Void> vote(URI votesUri) {
        return this.post(votesUri);
    }

    @Override
    public Promise<Void> unvote(URI votesUri) {
        return this.delete(votesUri);
    }

    @Override
    public Promise<Void> watch(URI watchersUri) {
        return this.post(watchersUri);
    }

    @Override
    public Promise<Void> unwatch(URI watchersUri) {
        return this.removeWatcher(watchersUri, this.getLoggedUsername());
    }

    @Override
    public Promise<Void> addWatcher(URI watchersUri, String username) {
        return this.post(watchersUri, JSONObject.quote((String)username));
    }

    @Override
    public Promise<Void> removeWatcher(URI watchersUri, String username) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)watchersUri);
        if (this.getVersionInfo().getBuildNumber() >= 640) {
            uriBuilder.queryParam("username", new Object[]{username});
        } else {
            uriBuilder.path(username).build(new Object[0]);
        }
        return this.delete(uriBuilder.build(new Object[0]));
    }

    @Override
    public Promise<Void> linkIssue(LinkIssuesInput linkIssuesInput) {
        URI uri = UriBuilder.fromUri((URI)this.baseUri).path("issueLink").build(new Object[0]);
        return this.post(uri, linkIssuesInput, new LinkIssuesInputGenerator(this.getVersionInfo()));
    }

    @Override
    public Promise<Void> addAttachment(URI attachmentsUri, InputStream inputStream, String filename) {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        entity.addPart("file", (ContentBody)new InputStreamBody(inputStream, filename));
        return this.postAttachments(attachmentsUri, entity);
    }

    @Override
    public Promise<Void> addAttachments(URI attachmentsUri, AttachmentInput ... attachments) {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (AttachmentInput attachmentInput : attachments) {
            entity.addPart("file", (ContentBody)new InputStreamBody(attachmentInput.getInputStream(), attachmentInput.getFilename()));
        }
        return this.postAttachments(attachmentsUri, entity);
    }

    @Override
    public Promise<Void> addAttachments(URI attachmentsUri, File ... files) {
        MultipartEntity entity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (File file : files) {
            entity.addPart("file", (ContentBody)new FileBody(file));
        }
        return this.postAttachments(attachmentsUri, entity);
    }

    @Override
    public Promise<Void> addComment(URI commentsUri, Comment comment) {
        return this.post(commentsUri, comment, new CommentJsonGenerator(this.getVersionInfo()));
    }

    @Override
    public Promise<InputStream> getAttachment(URI attachmentUri) {
        return this.callAndParse(this.client().newRequest(attachmentUri).get(), new AbstractAsynchronousRestClient.ResponseHandler<InputStream>(){

            @Override
            public InputStream handle(Response request) throws JSONException, IOException {
                return request.getEntityStream();
            }
        });
    }

    @Override
    public Promise<Void> addWorklog(URI worklogUri, WorklogInput worklogInput) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)worklogUri).queryParam("adjustEstimate", new Object[]{worklogInput.getAdjustEstimate().restValue});
        switch (worklogInput.getAdjustEstimate()) {
            case NEW: {
                uriBuilder.queryParam("newEstimate", new Object[]{Strings.nullToEmpty((String)worklogInput.getAdjustEstimateValue())});
                break;
            }
            case MANUAL: {
                uriBuilder.queryParam("reduceBy", new Object[]{Strings.nullToEmpty((String)worklogInput.getAdjustEstimateValue())});
            }
        }
        return this.post(uriBuilder.build(new Object[0]), worklogInput, new WorklogInputJsonGenerator());
    }

    private Promise<Void> postAttachments(URI attachmentsUri, MultipartEntity multipartEntity) {
        ResponsePromise responsePromise = this.client().newRequest(attachmentsUri).setEntity((EntityBuilder)new MultiPartEntityBuilder(multipartEntity)).setHeader("X-Atlassian-Token", "nocheck").post();
        return this.call(responsePromise);
    }

    private String getLoggedUsername() {
        return ((Session)this.sessionRestClient.getCurrentSession().claim()).getUsername();
    }
}

