/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.IssueLink;
import com.atlassian.jira.rest.client.domain.IssueLinkType;
import com.atlassian.jira.rest.client.domain.IssuelinksType;
import com.atlassian.jira.rest.client.internal.json.IssuelinksTypeJsonParserV5;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import java.net.URI;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class IssueLinkJsonParserV5
implements JsonObjectParser<IssueLink> {
    private final IssuelinksTypeJsonParserV5 issuelinksTypeJsonParserV5 = new IssuelinksTypeJsonParserV5();

    @Override
    public IssueLink parse(JSONObject json) throws JSONException {
        IssueLinkType.Direction direction;
        JSONObject link;
        IssuelinksType issuelinksType = this.issuelinksTypeJsonParserV5.parse(json.getJSONObject("type"));
        if (json.has("inwardIssue")) {
            link = json.getJSONObject("inwardIssue");
            direction = IssueLinkType.Direction.INBOUND;
        } else {
            link = json.getJSONObject("outwardIssue");
            direction = IssueLinkType.Direction.OUTBOUND;
        }
        String key = link.getString("key");
        Long id = JsonParseUtil.getOptionalLong(link, "id");
        URI targetIssueUri = JsonParseUtil.parseURI(link.getString("self"));
        IssueLinkType issueLinkType = new IssueLinkType(issuelinksType.getName(), direction.equals((Object)IssueLinkType.Direction.INBOUND) ? issuelinksType.getInward() : issuelinksType.getOutward(), direction);
        return new IssueLink(key, id, targetIssueUri, issueLinkType);
    }
}

