/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.ChangelogItem;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ChangelogItemJsonParser
implements JsonObjectParser<ChangelogItem> {
    @Override
    public ChangelogItem parse(JSONObject json) throws JSONException {
        ChangelogItem.FieldType fieldType;
        String fieldTypeStr = JsonParseUtil.getNestedString(json, "fieldtype");
        if ("jira".equalsIgnoreCase(fieldTypeStr)) {
            fieldType = ChangelogItem.FieldType.JIRA;
        } else if ("custom".equalsIgnoreCase(fieldTypeStr)) {
            fieldType = ChangelogItem.FieldType.CUSTOM;
        } else {
            throw new JSONException("[" + fieldTypeStr + "] does not represent a valid field type. Expected [jira] or [custom].");
        }
        String field = JsonParseUtil.getNestedString(json, "field");
        String from = JsonParseUtil.getNullableString(json, "from");
        String fromString = JsonParseUtil.getNullableString(json, "fromString");
        String to = JsonParseUtil.getNullableString(json, "to");
        String toString = JsonParseUtil.getNullableString(json, "toString");
        return new ChangelogItem(fieldType, field, from, fromString, to, toString);
    }
}

